/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.matlab;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.factory.TargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.smac.SimpleExecutor;
import ca.ubc.cs.beta.smac.ac.exceptions.TargetAlgorithmExecutionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRunner {
    private static final String TEMP_FILE_PREFIX = "algo-run-";
    private static final String TEMP_FILE_SUFFIX = ".ac-tmp";
    private static TargetAlgorithmEvaluator tae = null;
    private static Logger log = null;

    public void startManyRuns(Object func, Object theta_idx, Object instance_filenames, Object seed, Object censorLimits) {
    }

    public List<AlgorithmRun> validateRuns(List<AlgorithmRun> runs) {
        for (AlgorithmRun run : runs) {
            if (run.isRunResultWellFormed()) continue;
            System.err.println("[ERROR]: Run contains a malformed result:\n" + run);
        }
        return runs;
    }

    public List<AlgorithmRun> executeSurrogateRun(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, String[] dynamicClassPath) {
        if (log == null) {
            log = LoggerFactory.getLogger(this.getClass());
            Properties props = System.getProperties();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry ent : props.entrySet()) {
                sb.append(ent.getKey().toString()).append("=").append(ent.getValue().toString()).append("\n");
            }
            log.info("[System Properties] \n{}\n", (Object)sb.toString());
            Map<String, String> env = System.getenv();
            sb = new StringBuilder();
            for (String envName : env.keySet()) {
                sb.append(envName).append("=").append(env.get(envName)).append("\n");
            }
            log.info("[Enviroment Properties] \n{}\n", (Object)sb.toString());
        }
        if (tae == null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String dynamiccp : dynamicClassPath) {
                try {
                    urls.add(new File(dynamiccp).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]));
            try {
                TargetAlgorithmEvaluatorFactory taeFact = (TargetAlgorithmEvaluatorFactory)Class.forName("ca.ubc.cs.beta.models.surrogate.algorithmrun.SurrogateTargetAlgorithmEvaluatorFactory").newInstance();
                tae = taeFact.getTargetAlgorithmEvaluator(execConfig, 1);
                return tae.evaluateRun(runConfigs);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return tae.evaluateRun(runConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlgorithmRun> executeRun(AlgorithmExecutionConfig execConfig, List<RunConfig> instanceRunConfigs, String[] dynamicClassPath) {
        File tmpFileIn;
        PrintWriter out;
        File tmpFile;
        if (execConfig.getAlgorithmExecutable().contains("ruby surrogate_wrapper.rb")) {
            return this.executeSurrogateRun(execConfig, instanceRunConfigs, dynamicClassPath);
        }
        try {
            tmpFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            tmpFile.deleteOnExit();
            out = new PrintWriter(tmpFile);
            tmpFileIn = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new TargetAlgorithmExecutionException("Could not create temp file for output");
        }
        out.println(execConfig.getAlgorithmExecutable());
        out.println(execConfig.getAlgorithmExecutionDirectory());
        out.println(execConfig.getParamFile().getParamFileName());
        out.println("-1");
        for (RunConfig instanceRunConfig : instanceRunConfigs) {
            if (instanceRunConfig.getProblemInstanceSeedPair().getInstance().getInstanceName().indexOf(" ") != -1) {
                throw new TargetAlgorithmExecutionException("Instance name contains a space which breaks the file format we are being asked to write to");
            }
            out.print(instanceRunConfig.getProblemInstanceSeedPair().getInstance().getInstanceName());
            out.print(" ");
            out.print(instanceRunConfig.getProblemInstanceSeedPair().getSeed());
            out.print(" ");
            out.print(instanceRunConfig.getCutoffTime());
            out.print(" ");
            out.print(instanceRunConfig.getParamConfiguration().getFormattedParamString("", "=", "'", ", "));
            out.println();
        }
        out.close();
        SimpleExecutor smExec = new SimpleExecutor();
        boolean rubyExecutor = false;
        String rootDir = ".";
        String execString = "";
        if (rubyExecutor) {
            execString = "ruby scripts/al_run_configs_in_file_nodb.rb ";
        } else {
            StringBuilder dynamicClassPathStr = new StringBuilder();
            for (String s : dynamicClassPath) {
                dynamicClassPathStr.append(s).append(File.pathSeparator);
            }
            System.out.println("Class path for Simple Executor defined in: " + this.getClass().getCanonicalName());
            execString = "java -cp " + dynamicClassPathStr.toString() + " ca.ubc.cs.beta.smac.executors.AlgorithmRunConfiguratorExecutor ";
        }
        execString = execString + tmpFile.getAbsoluteFile() + " " + tmpFileIn.getAbsoluteFile();
        smExec.run(execString, rootDir);
        ArrayList<AlgorithmRun> runs = new ArrayList<AlgorithmRun>(instanceRunConfigs.size());
        try {
            BufferedReader r = null;
            try {
                String result;
                r = new BufferedReader(new FileReader(tmpFileIn));
                int i = 0;
                while ((result = r.readLine()) != null) {
                    System.out.println("Trying to parse " + result);
                    runs.add((AlgorithmRun)new ExistingAlgorithmRun(execConfig, instanceRunConfigs.get(i), result));
                    ++i;
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TargetAlgorithmExecutionException("Can't read results from Algorithm runs, the output file was not found");
        }
        catch (IOException e) {
            throw new TargetAlgorithmExecutionException("CSV Parsing failed for output file");
        }
        return runs;
    }
}

