/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.special.Gamma;
import net.sf.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class GammaDistribution
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public GammaDistribution() {
        this(1.0, 1.0);
    }

    public GammaDistribution(double a, double b) {
        this.setAlpha(a);
        this.setBeta(b);
    }

    public double cumulativeProbability(double x) throws NumericException {
        double ret = x <= 0.0 ? 0.0 : (Double.isInfinite(x) ? 1.0 : Gamma.regularizedGammaP(this.getAlpha(), x / this.getBeta()));
        return ret;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : (p <= 0.5 ? this.findInverseCumulativeProbability(p, 0.0, 0.5 * this.getAlpha() * this.getBeta(), this.getAlpha() * this.getBeta()) : this.findInverseCumulativeProbability(p, 0.0, this.getAlpha() * this.getBeta(), Double.POSITIVE_INFINITY))));
        return ret;
    }

    public void setAlpha(double a) {
        if (a <= 0.0 || Double.isNaN(a)) {
            throw new IllegalArgumentException("Alpha must be positive.");
        }
        this.alpha = a;
    }

    public void setBeta(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("Beta must be positive.");
        }
        this.beta = b;
    }
}

