/*
 * Decompiled with CFR 0.152.
 */
package org.StructureGraphic.v1;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.StructureGraphic.v1.DSChildren;
import org.StructureGraphic.v1.DSColor;
import org.StructureGraphic.v1.DSTreeNode;
import org.StructureGraphic.v1.DSValue;

public class DSTreeParser {
    public static DSTreeNode from(Object o) {
        if (o instanceof DSTreeNode) {
            return (DSTreeNode)o;
        }
        StringBuffer val = new StringBuffer();
        Color color = null;
        LinkedList<DSTreeNode> children = new LinkedList<DSTreeNode>();
        for (Field field : o.getClass().getFields()) {
            try {
                if (field.getAnnotation(DSValue.class) != null) {
                    val.append(field.getName()).append(": ").append(field.get(o)).append("\n");
                    continue;
                }
                if (field.getAnnotation(DSChildren.class) != null) {
                    if (field.getAnnotation(DSChildren.class).value() == DSChildren.DSChildField.ARRAY) {
                        for (Object child : (Object[])field.get(o)) {
                            children.add(DSTreeParser.from(child));
                        }
                        continue;
                    }
                    if (field.getAnnotation(DSChildren.class).value() == DSChildren.DSChildField.ITERABLE) {
                        for (Object child : (Iterable)field.get(o)) {
                            children.add(DSTreeParser.from(child));
                        }
                        continue;
                    }
                    children.add(DSTreeParser.from(field.get(o)));
                    continue;
                }
                if (field.getAnnotation(DSColor.class) == null) continue;
                color = (Color)field.get(o);
            }
            catch (IllegalArgumentException ex) {
                System.err.println(ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                System.err.println("Could not access " + field.getName() + "in " + field.getClass().getName());
            }
            catch (ClassCastException ex) {
                System.err.println("The annotation for " + field.getName() + "in " + field.getClass().getName() + " does not match it's type!");
            }
        }
        DSSimpleNode s = new DSSimpleNode(val.toString());
        s.children.addAll(children);
        s.color = color;
        return s;
    }

    public static DSTreeNode parseSimpleMultiline(String text) {
        return DSTreeParser.parseSimpleMultiline(new Scanner(text));
    }

    public static DSTreeNode parseSimpleMultiline(File file) throws FileNotFoundException {
        return DSTreeParser.parseSimpleMultiline(new Scanner(file));
    }

    public static DSTreeNode parseSimpleMultiline(Scanner sc) {
        LinkedList<Integer> depths = new LinkedList<Integer>();
        DSTreeStack st = new DSTreeStack();
        if (!sc.hasNextLine()) {
            return new DSSimpleNode("Empty");
        }
        while (sc.hasNextLine()) {
            String temp = sc.nextLine();
            String line = temp.trim();
            int spaceCount = temp.length() - line.length();
            if (depths.isEmpty()) {
                depths.addLast(spaceCount);
            } else {
                while ((Integer)depths.getLast() > spaceCount) {
                    st.finishLevel();
                    depths.removeLast();
                }
            }
            if ((Integer)depths.getLast() < spaceCount) {
                st.startLevel();
                depths.addLast(spaceCount);
            }
            st.addNode(line);
        }
        return st.getTree();
    }

    public static class DSSimpleNode
    implements DSTreeNode {
        @DSValue
        public String value;
        @DSChildren(value=DSChildren.DSChildField.ITERABLE)
        public List<DSTreeNode> children;
        @DSColor
        public Color color;

        public DSSimpleNode(String val, Color c) {
            this.value = val;
            this.children = new LinkedList<DSTreeNode>();
            this.color = c;
        }

        public DSSimpleNode(String val) {
            this(val, null);
        }

        public void add(DSTreeNode ... children) {
            for (DSTreeNode child : children) {
                this.children.add(child);
            }
        }

        public DSTreeNode[] DSgetChildren() {
            DSTreeNode[] c = new DSTreeNode[this.children.size()];
            return this.children.toArray(c);
        }

        public Object DSgetValue() {
            return this.value;
        }

        public Color DSgetColor() {
            return null;
        }
    }

    public static final class DSTreeStack {
        protected LinkedList<LinkedList<DSSimpleNode>> tree = new LinkedList();

        public DSTreeStack() {
            this.startLevel();
        }

        public void startLevel() {
            this.tree.add(new LinkedList());
        }

        public void finishLevel() {
            LinkedList<DSSimpleNode> children = this.tree.removeLast();
            DSSimpleNode parent = this.tree.getLast().getLast();
            parent.children.addAll(children);
        }

        public void addNode(Object val) {
            this.tree.getLast().add(new DSSimpleNode(val == null ? "null" : val.toString()));
        }

        public DSTreeNode getTree() {
            while (this.tree.size() > 1) {
                this.finishLevel();
            }
            if (this.tree.getFirst().size() > 1) {
                DSSimpleNode root = new DSSimpleNode("");
                root.children.addAll((Collection<DSTreeNode>)this.tree.getFirst());
                return root;
            }
            if (this.tree.getFirst().size() == 1) {
                return this.tree.getFirst().getFirst();
            }
            return new DSSimpleNode("Empty...");
        }
    }
}

