/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.local.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class LAGDHillClimber
extends HillClimber {
    static final long serialVersionUID = 7217437499439184344L;
    int m_nNrOfLookAheadSteps = 2;
    int m_nNrOfGoodOperations = 5;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        int k = this.m_nNrOfLookAheadSteps;
        int l = this.m_nNrOfGoodOperations;
        this.lookAheadInGoodDirectionsSearch(bayesNet, instances, k, l);
    }

    protected void lookAheadInGoodDirectionsSearch(BayesNet bayesNet, Instances instances, int nrOfLookAheadSteps, int nrOfGoodOperations) throws Exception {
        System.out.println("Initializing Cache");
        this.initCache(bayesNet, instances);
        while (nrOfLookAheadSteps > 1) {
            int i;
            System.out.println("Look Ahead Depth: " + nrOfLookAheadSteps);
            boolean legalSequence = true;
            double sequenceDeltaScore = 0.0;
            HillClimber.Operation[] bestOperation = new HillClimber.Operation[nrOfLookAheadSteps];
            bestOperation = this.getOptimalOperations(bayesNet, instances, nrOfLookAheadSteps, nrOfGoodOperations);
            for (i = 0; i < nrOfLookAheadSteps; ++i) {
                if (bestOperation[i] == null) {
                    legalSequence = false;
                    continue;
                }
                sequenceDeltaScore += bestOperation[i].m_fDeltaScore;
            }
            while (legalSequence && sequenceDeltaScore > 0.0) {
                System.out.println("Next Iteration..........................");
                for (i = 0; i < nrOfLookAheadSteps; ++i) {
                    this.performOperation(bayesNet, instances, bestOperation[i]);
                }
                bestOperation = this.getOptimalOperations(bayesNet, instances, nrOfLookAheadSteps, nrOfGoodOperations);
                sequenceDeltaScore = 0.0;
                for (i = 0; i < nrOfLookAheadSteps; ++i) {
                    if (bestOperation[i] != null) {
                        System.out.println(bestOperation[i].m_nOperation + " " + bestOperation[i].m_nHead + " " + bestOperation[i].m_nTail);
                        sequenceDeltaScore += bestOperation[i].m_fDeltaScore;
                    } else {
                        legalSequence = false;
                    }
                    System.out.println("DeltaScore: " + sequenceDeltaScore);
                    if (Thread.interrupted()) break;
                }
                if (!Thread.interrupted()) continue;
            }
            --nrOfLookAheadSteps;
            if (!Thread.interrupted()) continue;
            break;
        }
        HillClimber.Operation oOperation = this.getOptimalOperation(bayesNet, instances);
        while (oOperation != null && oOperation.m_fDeltaScore > 0.0) {
            this.performOperation(bayesNet, instances, oOperation);
            System.out.println("Performing last greedy steps");
            oOperation = this.getOptimalOperation(bayesNet, instances);
        }
        this.m_Cache = null;
    }

    protected HillClimber.Operation getAntiOperation(HillClimber.Operation oOperation) throws Exception {
        if (oOperation.m_nOperation == 0) {
            return new HillClimber.Operation(oOperation.m_nTail, oOperation.m_nHead, 1);
        }
        if (oOperation.m_nOperation == 1) {
            return new HillClimber.Operation(oOperation.m_nTail, oOperation.m_nHead, 0);
        }
        return new HillClimber.Operation(oOperation.m_nHead, oOperation.m_nTail, 2);
    }

    protected HillClimber.Operation[] getGoodOperations(BayesNet bayesNet, Instances instances, int nrOfGoodOperations) throws Exception {
        int i;
        HillClimber.Operation[] goodOperations = new HillClimber.Operation[nrOfGoodOperations];
        for (i = 0; i < nrOfGoodOperations; ++i) {
            goodOperations[i] = this.getOptimalOperation(bayesNet, instances);
            if (goodOperations[i] != null) {
                this.m_Cache.put(goodOperations[i], -1.0E100);
                continue;
            }
            i = nrOfGoodOperations;
        }
        for (i = 0; i < nrOfGoodOperations; ++i) {
            if (goodOperations[i] != null) {
                if (goodOperations[i].m_nOperation != 2) {
                    this.m_Cache.put(goodOperations[i], goodOperations[i].m_fDeltaScore);
                    continue;
                }
                this.m_Cache.put(goodOperations[i], goodOperations[i].m_fDeltaScore - this.m_Cache.m_fDeltaScoreAdd[goodOperations[i].m_nHead][goodOperations[i].m_nTail]);
                continue;
            }
            i = nrOfGoodOperations;
        }
        return goodOperations;
    }

    protected HillClimber.Operation[] getOptimalOperations(BayesNet bayesNet, Instances instances, int nrOfLookAheadSteps, int nrOfGoodOperations) throws Exception {
        if (nrOfLookAheadSteps == 1) {
            HillClimber.Operation[] bestOperation = new HillClimber.Operation[]{this.getOptimalOperation(bayesNet, instances)};
            return bestOperation;
        }
        double bestDeltaScore = 0.0;
        double currentDeltaScore = 0.0;
        HillClimber.Operation[] bestOperation = new HillClimber.Operation[nrOfLookAheadSteps];
        HillClimber.Operation[] goodOperations = new HillClimber.Operation[nrOfGoodOperations];
        HillClimber.Operation[] tempOperation = new HillClimber.Operation[nrOfLookAheadSteps - 1];
        goodOperations = this.getGoodOperations(bayesNet, instances, nrOfGoodOperations);
        for (int i = 0; i < nrOfGoodOperations; ++i) {
            if (goodOperations[i] != null) {
                int j;
                this.performOperation(bayesNet, instances, goodOperations[i]);
                tempOperation = this.getOptimalOperations(bayesNet, instances, nrOfLookAheadSteps - 1, nrOfGoodOperations);
                currentDeltaScore = goodOperations[i].m_fDeltaScore;
                for (j = 0; j < nrOfLookAheadSteps - 1; ++j) {
                    if (tempOperation[j] == null) continue;
                    currentDeltaScore += tempOperation[j].m_fDeltaScore;
                }
                this.performOperation(bayesNet, instances, this.getAntiOperation(goodOperations[i]));
                if (!(currentDeltaScore > bestDeltaScore)) continue;
                bestDeltaScore = currentDeltaScore;
                bestOperation[0] = goodOperations[i];
                for (j = 1; j < nrOfLookAheadSteps; ++j) {
                    bestOperation[j] = tempOperation[j - 1];
                }
                continue;
            }
            i = nrOfGoodOperations;
        }
        return bestOperation;
    }

    @Override
    public void setMaxNrOfParents(int nMaxNrOfParents) {
        this.m_nMaxNrOfParents = nMaxNrOfParents;
    }

    @Override
    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    public void setNrOfLookAheadSteps(int nNrOfLookAheadSteps) {
        this.m_nNrOfLookAheadSteps = nNrOfLookAheadSteps;
    }

    public int getNrOfLookAheadSteps() {
        return this.m_nNrOfLookAheadSteps;
    }

    public void setNrOfGoodOperations(int nNrOfGoodOperations) {
        this.m_nNrOfGoodOperations = nNrOfGoodOperations;
    }

    public int getNrOfGoodOperations() {
        return this.m_nNrOfGoodOperations;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tLook Ahead Depth", "L", 2, "-L <nr of look ahead steps>"));
        newVector.addElement(new Option("\tNr of Good Operations", "G", 5, "-G <nr of good operations>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            newVector.addElement((Option)enm.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sNrOfLookAheadSteps = Utils.getOption('L', options);
        if (sNrOfLookAheadSteps.length() != 0) {
            this.setNrOfLookAheadSteps(Integer.parseInt(sNrOfLookAheadSteps));
        } else {
            this.setNrOfLookAheadSteps(2);
        }
        String sNrOfGoodOperations = Utils.getOption('G', options);
        if (sNrOfGoodOperations.length() != 0) {
            this.setNrOfGoodOperations(Integer.parseInt(sNrOfGoodOperations));
        } else {
            this.setNrOfGoodOperations(5);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[9 + superOptions.length];
        int current = 0;
        options[current++] = "-L";
        options[current++] = "" + this.m_nNrOfLookAheadSteps;
        options[current++] = "-G";
        options[current++] = "" + this.m_nNrOfGoodOperations;
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a Look Ahead Hill Climbing algorithm called LAGD Hill Climbing. Unlike Greedy Hill Climbing it doesn't calculate a best greedy operation (adding, deleting or reversing an arc) but a sequence of nrOfLookAheadSteps operations, which leads to a network structure whose score is most likely higher in comparison to the network obtained by performing a sequence of nrOfLookAheadSteps greedy operations. The search is not restricted by an order on the variables (unlike K2). The difference with B and B2 is that this hill climber also considers arrows part of the naive Bayes structure for deletion.";
    }

    public String nrOfLookAheadStepsTipText() {
        return "Sets the Number of Look Ahead Steps. 'nrOfLookAheadSteps = 2' means that all network structures in a distance of 2 (from the current network structure) are taken into account for the decision which arcs to add, remove or reverse. 'nrOfLookAheadSteps = 1' results in Greedy Hill Climbing.";
    }

    public String nrOfGoodOperationsTipText() {
        return "Sets the Number of Good Operations per Look Ahead Step. 'nrOfGoodOperations = 5' means that for the next Look Ahead Step only the 5 best Operations (adding, deleting or reversing an arc) are taken into account for the calculation of the best sequence consisting of nrOfLookAheadSteps operations.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

