/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractAlgorithmRunner
implements AlgorithmRunner {
    protected final AlgorithmExecutionConfig execConfig;
    protected final List<RunConfig> runConfigs;
    protected final List<AlgorithmRun> runs;

    public AbstractAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs) {
        if (execConfig == null || runConfigs == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.execConfig = execConfig;
        this.runConfigs = runConfigs;
        ArrayList<CommandLineAlgorithmRun> runs = new ArrayList<CommandLineAlgorithmRun>(runConfigs.size());
        for (RunConfig instConf : runConfigs) {
            runs.add(new CommandLineAlgorithmRun(execConfig, instConf));
        }
        this.runs = Collections.unmodifiableList(runs);
    }

    @Override
    public abstract List<AlgorithmRun> run();
}

