/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.configspace;

import ca.ubc.cs.beta.aclib.configspace.LineType;
import ca.ubc.cs.beta.aclib.configspace.NormalizedRange;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.misc.java.io.FileReaderNoException.FileReaderNoException;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ParamConfigurationSpace
implements Serializable {
    private static final long serialVersionUID = -9137375058810057209L;
    private final Map<String, List<String>> values;
    private final Map<String, String> defaultValues;
    private final Map<String, Map<String, List<String>>> dependentValues;
    private final Map<String, Boolean> isContinuous;
    @Deprecated
    private final List<String> paramNames;
    private final Map<String, Map<String, Integer>> categoricalValueMap;
    private final String absoluteFileName;
    private final Map<String, NormalizedRange> contNormalizedRanges;
    private final Map<String, Integer> paramKeyIndexMap;
    private final boolean[] parameterDomainContinuous;
    private final int[] categoricalSize;
    private final List<int[][]> forbiddenParameterValuesList;
    public static final int INVALID_CATEGORICAL_SIZE = 0;
    static final int NEIGHBOURS_FOR_CONTINUOUS = 4;
    private final int numberOfParameters;
    private final int[][] condParents;
    private final int[][][] condParentVals;
    private Random random;
    private boolean hasRealParameterFile;
    private final List<String> forbiddenLines;
    List<String> authorativeParameterNameOrder;

    public ParamConfigurationSpace(String filename, Random random) {
        this(new File(filename), random);
    }

    public ParamConfigurationSpace(String filename) {
        this(new File(filename));
    }

    public ParamConfigurationSpace(File file) {
        this(file, SeedableRandomSingleton.getRandom());
    }

    public ParamConfigurationSpace(Reader reader) {
        this(reader, SeedableRandomSingleton.getRandom(), "ReaderOnly-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1.0E7));
        this.hasRealParameterFile = false;
    }

    public ParamConfigurationSpace(File file, Random random) {
        this(new FileReaderNoException(file), random, file.getAbsolutePath());
    }

    /*
     * Exception decompiling
     */
    public ParamConfigurationSpace(Reader file, Random random, String absoluteFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getParamFileName() {
        return this.absoluteFileName;
    }

    private void parseLine(String line) {
        LineType type = LineType.OTHER;
        int commentStart = line.indexOf("#");
        line = line.trim();
        if (commentStart >= 0) {
            line = line.substring(0, commentStart).trim();
        }
        if (line.length() == 0) {
            return;
        }
        if (line.indexOf("|") >= 0) {
            type = LineType.CONDITIONAL;
        } else if (line.trim().substring(0, 1).equals("{")) {
            type = LineType.FORBIDDEN;
        } else {
            if (line.indexOf("[") < 0) {
                type = LineType.OTHER;
                if (line.trim().equals("Conditionals:")) {
                    return;
                }
                if (line.trim().equals("Forbidden:")) {
                    return;
                }
                throw new IllegalArgumentException("Cannot parse the following line:" + line);
            }
            if (line.indexOf("[") != line.lastIndexOf("[")) {
                type = LineType.CONTINUOUS;
            } else if (line.trim().indexOf("{") > 1 && line.trim().indexOf("}") > 1) {
                type = LineType.CATEGORICAL;
            } else {
                throw new IllegalArgumentException("Syntax error parsing line " + line + " probably malformed");
            }
        }
        switch (type) {
            case CONDITIONAL: {
                this.parseConditionalLine(line);
                break;
            }
            case CATEGORICAL: {
                this.parseCategoricalLine(line);
                break;
            }
            case CONTINUOUS: {
                this.parseContinuousLine(line);
                break;
            }
            case FORBIDDEN: {
                this.forbiddenLines.add(line);
                break;
            }
            default: {
                throw new IllegalStateException("Not sure how I can be parsing some other type, ");
            }
        }
    }

    private void parseForbiddenLine(String line) {
        String originalLine = line;
        if (line.trim().indexOf("{", 1) != -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained more than one { in line: " + originalLine);
        }
        if ((line = line.replace("{", "")).trim().indexOf("}") == -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained no closing brace \"}\" in line: " + originalLine);
        }
        if ((line = line.replaceFirst("}", "")).trim().indexOf("}") != -1) {
            throw new IllegalArgumentException("Line specifying forbidden parameters contained multiple closing braces \"}\" in line: " + originalLine);
        }
        String[] nameValuePairs = line.split(",");
        ArrayList<int[]> forbiddenIndexValuePairs = new ArrayList<int[]>();
        for (String nameValuePair : nameValuePairs) {
            Object[] nvPairArr = nameValuePair.split("=");
            if (nvPairArr.length != 2) {
                throw new IllegalArgumentException("Line specifying forbidden parameters contained an name value pair that could not be parsed: " + Arrays.toString(nvPairArr) + " in line: " + originalLine);
            }
            String name = nvPairArr[0].trim();
            Integer indexIntoValueArrays = this.paramKeyIndexMap.get(name);
            if (indexIntoValueArrays == null) {
                throw new IllegalArgumentException("Unknown parameter " + name + " in line: " + originalLine);
            }
            String value = ((String)nvPairArr[1]).trim();
            if (this.isContinuous.get(name).booleanValue()) {
                throw new IllegalArgumentException("Forbidden Parameter Declarations can only exclude combinations of categorical parameters " + name + " is continuous; in line: " + line);
            }
            Integer valueIndex = this.categoricalValueMap.get(name).get(value);
            if (valueIndex == null) {
                throw new IllegalArgumentException("Invalid parameter value " + value + " for parameter " + name + " in line: " + line);
            }
            int[] nvPairArrayForm = new int[]{indexIntoValueArrays, valueIndex};
            forbiddenIndexValuePairs.add(nvPairArrayForm);
        }
        this.forbiddenParameterValuesList.add((int[][])forbiddenIndexValuePairs.toArray((T[])new int[0][0]));
    }

    private void parseContinuousLine(String line) {
        boolean intValuesOnly;
        int secondBracket;
        String name = this.getName(line);
        int firstBracket = line.indexOf("[");
        String domainValues = line.substring(firstBracket + 1, secondBracket = line.indexOf("]"));
        String[] contValues = domainValues.split(",");
        if (contValues.length != 2) {
            throw new IllegalArgumentException("Expected two parameter values (or one comma between the first brackets) from line \"" + line + "\" but received " + contValues.length);
        }
        double min = Double.valueOf(contValues[0]);
        double max = Double.valueOf(contValues[1]);
        String defaultValue = this.getDefault(secondBracket, line);
        this.paramNames.add(name);
        this.isContinuous.put(name, Boolean.TRUE);
        this.values.put(name, Collections.emptyList());
        this.defaultValues.put(name, defaultValue);
        String lineRemaining = line.substring(line.indexOf("]", secondBracket + 1) + 1);
        boolean logScale = lineRemaining.length() > 0 && lineRemaining.trim().contains("l");
        lineRemaining = lineRemaining.replaceFirst("l", "").trim();
        boolean bl = intValuesOnly = lineRemaining.length() > 0 && lineRemaining.trim().contains("i");
        if (intValuesOnly) {
            try {
                if (!this.isIntegerDouble(Double.valueOf(contValues[0]))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(Double.valueOf(contValues[1]))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
                if (!this.isIntegerDouble(Double.valueOf(defaultValue))) {
                    throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("This parameter is marked as integer, only integer values are permitted for the bounds and default on line:" + line);
            }
        }
        if ((lineRemaining = lineRemaining.replaceFirst("i", "").trim()).trim().length() != 0) {
            throw new IllegalArgumentException("Unknown or duplicate modifier(s): " + lineRemaining + " in line: " + line);
        }
        try {
            this.contNormalizedRanges.put(name, new NormalizedRange(min, max, logScale, intValuesOnly));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "; error occured while parsing line: " + line);
        }
        String subString = line.substring(line.indexOf("]") + 1, line.indexOf("[", line.indexOf("]"))).trim();
        if (subString.length() > 0) {
            throw new IllegalArgumentException("Invalid Characters detected between domain and default value on line : " + line);
        }
    }

    private void parseCategoricalLine(String line) {
        String name = this.getName(line);
        List<String> paramValues = this.getValues(line);
        String defaultValue = this.getDefault(0, line);
        this.paramNames.add(name);
        this.values.put(name, paramValues);
        LinkedHashMap<String, Integer> valueMap = new LinkedHashMap<String, Integer>();
        int lastIndexOf = line.lastIndexOf("]");
        int i = 0;
        for (String value : paramValues) {
            valueMap.put(value, i);
            ++i;
        }
        this.categoricalValueMap.put(name, valueMap);
        this.defaultValues.put(name, defaultValue);
        this.isContinuous.put(name, Boolean.FALSE);
        String remaining = line.substring(lastIndexOf + 1).trim();
        if (remaining.contains("i")) {
            throw new IllegalArgumentException("Cannot set categorical value as having integral only values on line " + line);
        }
        if (remaining.contains("l")) {
            throw new IllegalArgumentException("Cannot set categorical value as being selected with a log distribution" + line);
        }
        if (remaining.length() > 0) {
            throw new IllegalArgumentException("Extra flags set for categorical value (flags are not permitted on categorical values) on line : " + line);
        }
    }

    private void parseConditionalLine(String line) {
        String name2;
        String lineToParse = line;
        String name1 = this.getName(line);
        if (name1.equals(name2 = this.getName(line.substring(line.indexOf("|") + 1)))) {
            throw new IllegalArgumentException("Parameter " + name1 + " cannot be conditional on itself in line: " + line);
        }
        lineToParse = lineToParse.replaceFirst(name1, "");
        lineToParse = lineToParse.replaceFirst("|", "");
        lineToParse = lineToParse.replaceFirst(name2, "");
        if ((lineToParse = lineToParse.trim()).indexOf(" in ") < 0) {
            throw new IllegalStateException("Unknown or missing operator in line: " + line);
        }
        List<String> condValues = this.getValues(line);
        Map<String, List<String>> dependencies = this.dependentValues.get(name1);
        if (dependencies == null) {
            dependencies = new HashMap<String, List<String>>();
            this.dependentValues.put(name1, dependencies);
        }
        if (dependencies.get(name2) != null) {
            throw new IllegalArgumentException("Parameter " + name1 + " already has a previous dependency for " + name2 + " values {" + dependencies.get(name2).toString() + "}. Parameter dependencies respecified in line: " + line);
        }
        dependencies.put(name2, condValues);
    }

    private String getName(String line) {
        return this.getName(line, 0);
    }

    private String getName(String line, int offset) {
        line = line.trim();
        int firstSpace = line.indexOf(" ");
        int firstPipe = line.indexOf("|");
        int firstCurly = line.indexOf("{");
        int firstSquare = line.indexOf("[");
        if (firstSpace == -1) {
            firstSpace = Integer.MAX_VALUE;
        }
        if (firstPipe == -1) {
            firstPipe = Integer.MAX_VALUE;
        }
        if (firstCurly == -1) {
            firstCurly = Integer.MAX_VALUE;
        }
        if (firstSquare == -1) {
            firstSquare = Integer.MAX_VALUE;
        }
        int nameBoundary = Math.min(firstSpace, firstPipe);
        nameBoundary = Math.min(nameBoundary, firstCurly);
        String name = line.substring(offset, nameBoundary = Math.min(nameBoundary, firstSquare)).trim();
        if (name.length() == 0) {
            throw new IllegalArgumentException("Did Not Parse a Parameter Name in line: " + line);
        }
        return name;
    }

    private String getDefault(int offset, String line) {
        String defaultValue = line.substring(line.indexOf("[", offset + 1) + 1, line.indexOf("]", offset + 1)).trim();
        if (defaultValue.length() == 0) {
            throw new IllegalArgumentException("Invalid Default Value specified in line: " + line);
        }
        return defaultValue;
    }

    private List<String> getValues(String line) {
        String oLine = line;
        int start = line.indexOf("{");
        int end = line.indexOf("}");
        line = line.substring(start + 1, end);
        line = line.replace(',', '\n');
        BufferedReader r = new BufferedReader(new StringReader(line));
        LinkedList<String> strings = new LinkedList<String>();
        try {
            String value;
            while ((value = r.readLine()) != null) {
                if (value.trim().length() == 0) {
                    throw new IllegalArgumentException("Value cannot be empty (consist only of whitespace) in line: " + oLine);
                }
                strings.add(value.trim());
            }
        }
        catch (IOException e) {
            System.err.println("Some random IOException occured?");
            e.printStackTrace();
            throw new IllegalStateException("An exception occured while reading values from (" + oLine + ") we mistakenly thought this would never happen, please contact developer", e);
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(strings);
        if (set.size() < strings.size()) {
            throw new IllegalStateException("Duplicate Value detected in line: " + oLine);
        }
        return strings;
    }

    public List<String> getParameterNames() {
        return Collections.unmodifiableList(this.paramNames);
    }

    public Map<String, Boolean> getContinuousMap() {
        return Collections.unmodifiableMap(this.isContinuous);
    }

    public Map<String, List<String>> getValuesMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map<String, String> getDefaultValuesMap() {
        return Collections.unmodifiableMap(this.defaultValues);
    }

    public Map<String, Map<String, List<String>>> getDependentValuesMap() {
        return Collections.unmodifiableMap(this.dependentValues);
    }

    public Map<String, Map<String, Integer>> getCategoricalValueMap() {
        return Collections.unmodifiableMap(this.categoricalValueMap);
    }

    public Map<String, NormalizedRange> getNormalizedRangeMap() {
        return Collections.unmodifiableMap(this.contNormalizedRanges);
    }

    public synchronized List<String> getParameterNamesInAuthorativeOrder() {
        if (this.authorativeParameterNameOrder == null) {
            this.authorativeParameterNameOrder = new ArrayList<String>(this.paramNames.size());
            this.authorativeParameterNameOrder.addAll(this.paramNames);
            Collections.sort(this.authorativeParameterNameOrder);
        }
        return Collections.unmodifiableList(this.authorativeParameterNameOrder);
    }

    public int hashCode() {
        return this.absoluteFileName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ParamConfigurationSpace) {
            ParamConfigurationSpace po = (ParamConfigurationSpace)o;
            return po.absoluteFileName.equals(this.absoluteFileName);
        }
        return false;
    }

    public String toString() {
        return "ParamFile:" + this.absoluteFileName;
    }

    public ParamConfiguration getRandomConfiguration() {
        return this.getRandomConfiguration(false);
    }

    public ParamConfiguration getRandomConfiguration(boolean allowForbiddenParameters) {
        ParamConfiguration p;
        do {
            double[] valueArray = new double[this.numberOfParameters];
            for (int i = 0; i < this.numberOfParameters; ++i) {
                valueArray[i] = this.parameterDomainContinuous[i] ? this.random.nextDouble() : (double)(this.random.nextInt(this.categoricalSize[i]) + 1);
            }
            p = new ParamConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
        } while (!allowForbiddenParameters && p.isForbiddenParamConfiguration());
        return p;
    }

    public ParamConfiguration getDefaultConfiguration() {
        ParamConfiguration p = this.getEmptyConfiguration();
        Map<String, String> defaultMap = this.getDefaultValuesMap();
        p.putAll((Map<? extends String, ? extends String>)defaultMap);
        return p;
    }

    public ParamConfiguration getEmptyConfiguration() {
        return new ParamConfiguration(this, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
    }

    public ParamConfiguration getConfigurationFromValueArray(double[] valueArray) {
        if (valueArray.length != this.categoricalSize.length) {
            throw new IllegalArgumentException("Value Array Length is not the right size " + valueArray.length + " vs " + this.categoricalSize.length);
        }
        return new ParamConfiguration(this, (double[])valueArray.clone(), this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
    }

    public ParamConfiguration getConfigurationFromString(String paramString, ParamConfiguration.StringFormat f) {
        try {
            ParamConfiguration config;
            String trySpecialParamString = paramString.trim().toUpperCase();
            if (trySpecialParamString.equals("DEFAULT") || trySpecialParamString.equals("<DEFAULT>")) {
                return this.getDefaultConfiguration();
            }
            if (trySpecialParamString.equals("RANDOM") || trySpecialParamString.equals("<RANDOM>")) {
                return this.getRandomConfiguration();
            }
            switch (f) {
                case NODB_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case NODB_SYNTAX: {
                    String[] params;
                    config = new ParamConfiguration(this, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString;
                    for (String param : params = tmpParamString.split("\\s-")) {
                        if (param.equals("")) continue;
                        Object[] paramSplit = param.trim().split(" ");
                        try {
                            if (paramSplit[1].trim().equals("NaN")) continue;
                            config.put(paramSplit[0].trim(), ((String)paramSplit[1]).replaceAll("'", "").trim());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.out.println(paramString);
                            System.out.println(tmpParamString);
                            System.out.println((Object)f);
                            System.out.println(Arrays.toString(paramSplit));
                            throw e;
                        }
                    }
                    break;
                }
                case STATEFILE_SYNTAX_WITH_INDEX: {
                    paramString = paramString.replaceFirst("\\A\\d+:", "");
                }
                case STATEFILE_SYNTAX: {
                    String[] params;
                    config = new ParamConfiguration(this, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = " " + paramString.replaceAll("'", "");
                    for (String param : params = tmpParamString.split(",")) {
                        String[] paramSplit;
                        if (param.equals("") || (paramSplit = param.trim().split("="))[1].trim().equals("NaN")) continue;
                        config.put(paramSplit[0].trim(), paramSplit[1].trim());
                    }
                    break;
                }
                case ARRAY_STRING_SYNTAX: {
                    double[] valueArray = new double[this.numberOfParameters];
                    String tmpParamString = paramString;
                    String[] params = tmpParamString.split(",");
                    if (params.length != valueArray.length) {
                        throw new IllegalArgumentException("Param String Value Array expected to be: " + valueArray.length + " but got a string of length " + paramString.length());
                    }
                    for (int i = 0; i < valueArray.length; ++i) {
                        valueArray[i] = Double.valueOf(params[i]);
                    }
                    config = new ParamConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    break;
                }
                case SURROGATE_EXECUTOR: {
                    double[] valueArray = new double[this.numberOfParameters];
                    config = new ParamConfiguration(this, valueArray, this.categoricalSize, this.parameterDomainContinuous, this.paramKeyIndexMap);
                    String tmpParamString = paramString.trim().replaceAll("-P", "");
                    String[] params = tmpParamString.split(" ");
                    HashSet<String> namesSpecified = new HashSet<String>();
                    for (int i = 0; i < params.length; ++i) {
                        String[] param = params[i].split("=");
                        if (param.length != 2) {
                            throw new IllegalArgumentException("Param String could not parse portion of string " + paramString + " error occured while seperating: (" + params[i] + ")");
                        }
                        namesSpecified.add(param[0].trim());
                        config.put(param[0].trim(), param[1].trim());
                    }
                    if (((Object)namesSpecified).equals(config.getActiveParameters())) break;
                    HashSet<String> missingButRequired = new HashSet<String>();
                    HashSet<String> specifiedButNotActive = new HashSet<String>();
                    missingButRequired.addAll(config.getActiveParameters());
                    missingButRequired.removeAll(namesSpecified);
                    specifiedButNotActive.addAll(namesSpecified);
                    specifiedButNotActive.removeAll(config.getActiveParameters());
                    throw new IllegalArgumentException("Param String specified some combination of inactive parameters and/or missed active parameters. \nRequired Parameters: " + config.getActiveParameters().size() + "\nSpecified Parameters: " + namesSpecified.size() + "\nRequired But Missing: " + ((Object)missingButRequired).toString() + "\nSpecified But Not Required" + ((Object)specifiedButNotActive).toString());
                }
                default: {
                    throw new IllegalArgumentException("Parsing not implemented for String Format");
                }
            }
            return config;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "\n String: " + paramString + " Format: " + (Object)((Object)f));
        }
    }

    public int[] getCategoricalSize() {
        return (int[])this.categoricalSize.clone();
    }

    public int[][] getCondParentsArray() {
        return (int[][])this.condParents.clone();
    }

    public int[][][] getCondParentValsArray() {
        return (int[][][])this.condParentVals.clone();
    }

    public Random getPRNG() {
        return this.random;
    }

    public void setPRNG(Random r) {
        this.random = r;
    }

    public boolean isForbiddenParamConfiguration(double[] valueArray) {
        for (int[][] forbiddenParamValues : this.forbiddenParameterValuesList) {
            boolean match = true;
            for (int[] forbiddenParamValue : forbiddenParamValues) {
                if (valueArray[forbiddenParamValue[0]] == (double)(forbiddenParamValue[1] + 1)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean isIntegerDouble(double d) {
        return d - Math.floor(d) == 0.0;
    }

    public boolean hasRealParameterFile() {
        return this.hasRealParameterFile;
    }
}

