/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.expectedimprovement;

import ca.ubc.cs.beta.aclib.expectedimprovement.ExpectedImprovementFunction;
import ca.ubc.cs.beta.aclib.misc.math.ArrayMathOps;

public strictfp class ExpectedExponentialImprovement
implements ExpectedImprovementFunction {
    private double normcdf(double x) {
        double b1 = 0.31938153;
        double b2 = -0.356563782;
        double b3 = 1.781477937;
        double b4 = -1.821255978;
        double b5 = 1.330274429;
        double p = 0.2316419;
        double c = 0.39894228;
        if (x >= 0.0) {
            double t = 1.0 / (1.0 + p * x);
            return 1.0 - c * ArrayMathOps.exp(-x * x / 2.0) * t * (t * (t * (t * (t * b5 + b4) + b3) + b2) + b1);
        }
        double t = 1.0 / (1.0 - p * x);
        return c * ArrayMathOps.exp(-x * x / 2.0) * t * (t * (t * (t * (t * b5 + b4) + b3) + b2) + b1);
    }

    private double normcdfln(double x) {
        double pi = Math.PI;
        if (x > -6.5) {
            return ArrayMathOps.log(this.normcdf(x));
        }
        double z = ArrayMathOps.pow(x, -2.0);
        double y = z * (-1.0 + z * (2.5 + z * (-12.333333333333334 + z * (88.25 + z * (-816.2 + z * (9200.833333333334 + z * -854197.0 / 7.0))))));
        return y - 0.5 * ArrayMathOps.log(2.0 * pi) - 0.5 * x * x - ArrayMathOps.log(-x);
    }

    private double normpdf(double x) {
        double pi = Math.PI;
        return 1.0 / ArrayMathOps.sqrt(2.0 * pi) * ArrayMathOps.exp(-x * x / 2.0);
    }

    private double[] log_exp_exponentiated_imp(double[] fmin_samples, double[] mus, double[] sigmas) {
        int numSamples = fmin_samples.length;
        int numMus = mus.length;
        double[] log_expEI = new double[mus.length];
        if (numSamples > 1) {
            throw new IllegalArgumentException("log_exp_exponentiated_imp not yet implemented for numSamples>1; can do that based on logsumexp trick.");
        }
        for (int i = 0; i < numMus; ++i) {
            log_expEI[i] = 0.0;
            for (int s = 0; s < numSamples; ++s) {
                double cdfln_2;
                double d;
                double cdfln_1 = this.normcdfln((fmin_samples[s] - mus[i]) / sigmas[i]);
                double c = fmin_samples[s] + cdfln_1;
                log_expEI[i] = c <= (d = sigmas[i] * sigmas[i] / 2.0 + mus[i] + (cdfln_2 = this.normcdfln((fmin_samples[s] - mus[i]) / sigmas[i] - sigmas[i]))) ? d : d + ArrayMathOps.log(ArrayMathOps.exp(c - d) - 1.0);
            }
        }
        return log_expEI;
    }

    @Override
    public double[] computeNegativeExpectedImprovement(double f_min_samples, double[] predmean, double[] predvar) {
        if (predmean.length != predvar.length) {
            throw new IllegalArgumentException("Expected predmean and predvar to have the same length");
        }
        double log10 = Math.log(10.0);
        double[] fmin = new double[]{log10 * f_min_samples};
        double[] expImp = this.log_exp_exponentiated_imp(fmin, ArrayMathOps.times(log10, predmean), ArrayMathOps.times(log10, ArrayMathOps.sqrt(predvar)));
        for (int i = 0; i < expImp.length; ++i) {
            expImp[i] = -expImp[i];
        }
        return expImp;
    }
}

