/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.model.data;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.misc.math.ArrayMathOps;
import ca.ubc.cs.beta.aclib.misc.math.MessyMathHelperClass;
import ca.ubc.cs.beta.aclib.model.data.AbstractSanitizedModelData;
import ca.ubc.cs.beta.models.fastrf.RoundingMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCAModelDataSanitizer
extends AbstractSanitizedModelData {
    private final double[][] pcaVec;
    private final double[] pcaCoeff;
    private final int[] sub;
    private final double[] means;
    private final double[] stdDev;
    private final double[][] pcaFeatures;
    private final double[][] prePCAInstanceFeatures;
    private final double[] responseValues;
    private final ParamConfigurationSpace configSpace;
    private final double[][] configs;
    private final boolean logModel;
    public static int index = 0;
    public static final String filename = "/tmp/lastoutput-mds";
    static boolean writeOutput = true;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private int[][] theta_inst_idxs;
    private boolean[] censoredResponseValues;
    public static boolean printFeatures = false;

    public static String explode(String s) {
        return s.replaceAll("]", "}\n").replaceAll("\\[", "{");
    }

    public PCAModelDataSanitizer(double[][] instanceFeatures, double[][] paramValues, int numPCA, double[] responseValues, int[] usedInstances, boolean logModel, int[][] theta_inst_idxs, boolean[] censoredResponseValues) {
        this(instanceFeatures, paramValues, numPCA, responseValues, usedInstances, logModel, theta_inst_idxs, censoredResponseValues, null);
    }

    public PCAModelDataSanitizer(double[][] instanceFeatures, double[][] paramValues, int numPCA, double[] responseValues, int[] usedInstancesIdxs, boolean logModel, int[][] theta_inst_idxs, boolean[] censoredResponseValues, ParamConfigurationSpace configSpace) {
        int[] mySub;
        this.configSpace = configSpace;
        this.configs = paramValues;
        this.responseValues = responseValues;
        this.theta_inst_idxs = theta_inst_idxs;
        this.censoredResponseValues = censoredResponseValues;
        this.prePCAInstanceFeatures = ArrayMathOps.copy(instanceFeatures);
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            if (!printFeatures) {
                for (int i = 0; i < instanceFeatures.length; ++i) {
                    System.out.println(i + ":" + Arrays.toString(instanceFeatures[i]));
                }
                printFeatures = true;
            }
            System.out.println("Instance Features Hash: " + ArrayMathOps.matlabHashCode(instanceFeatures));
            System.out.println("Param Values Hash:" + ArrayMathOps.matlabHashCode(paramValues));
            System.out.println("Used Instance IDs:" + Arrays.toString(usedInstancesIdxs));
            System.out.println("Num PCA:" + numPCA);
            System.out.println("Response Values:" + Arrays.toString(responseValues));
            System.out.println("Log Model: " + logModel);
        }
        instanceFeatures = ArrayMathOps.copy(instanceFeatures);
        writeOutput = false;
        if (writeOutput) {
            File f = new File("/tmp/lastoutput-mds-" + index);
            f.delete();
            try {
                ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(f));
                o.writeObject(instanceFeatures);
                o.writeObject(paramValues);
                o.writeObject(responseValues);
                o.writeObject(usedInstancesIdxs);
                System.out.println("Calls written & deleted to: /tmp/lastoutput-mds-" + index++);
                o.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        MessyMathHelperClass pca = new MessyMathHelperClass();
        double[][] usedInstanceFeatures = new double[usedInstancesIdxs.length][];
        for (int i = 0; i < usedInstanceFeatures.length; ++i) {
            usedInstanceFeatures[i] = instanceFeatures[usedInstancesIdxs[i]];
        }
        int[] constFeatures = pca.constantColumnsWithMissingValues(usedInstanceFeatures);
        instanceFeatures = pca.removeColumns(instanceFeatures, constFeatures);
        this.log.info("Discarding {} constant inputs of {} in total.", (Object)constFeatures.length, (Object)this.prePCAInstanceFeatures[0].length);
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            System.out.print("Constant Columns: ");
            for (int i = 0; i < constFeatures.length; ++i) {
                System.out.print(constFeatures[i] + 1 + ",");
            }
            System.out.println("\n");
            System.out.println("Discarding " + constFeatures.length + "  constant inputs of " + this.prePCAInstanceFeatures[0].length + " total ");
        }
        double[][] instanceFeaturesT = pca.transpose(instanceFeatures);
        double[] firstStdDev = pca.getRowStdDev(instanceFeaturesT);
        this.logModel = logModel;
        if (logModel) {
            pca.max(responseValues, 0.005);
            pca.log10(responseValues);
        }
        if ((mySub = pca.getSub(firstStdDev)).length == 0) {
            this.sub = new int[0];
            this.means = new double[0];
            this.stdDev = new double[0];
            this.pcaCoeff = new double[0];
            this.pcaVec = new double[0][];
            this.pcaFeatures = new double[instanceFeatures.length][1];
            return;
        }
        if (instanceFeatures[0].length < numPCA) {
            this.sub = new int[0];
            this.means = new double[0];
            this.stdDev = new double[0];
            this.pcaCoeff = new double[0];
            this.pcaVec = new double[0][];
            this.pcaFeatures = instanceFeatures;
            return;
        }
        this.sub = mySub;
        instanceFeatures = pca.keepColumns(instanceFeatures, this.sub);
        instanceFeaturesT = pca.transpose(instanceFeatures);
        this.means = pca.getRowMeans(instanceFeaturesT);
        this.stdDev = pca.getRowStdDev(instanceFeaturesT);
        pca.perColumnOperation(instanceFeatures, this.means, MessyMathHelperClass.Operation.SUBTRACT);
        pca.perColumnOperation(instanceFeatures, this.stdDev, MessyMathHelperClass.Operation.DIVIDE);
        this.pcaCoeff = pca.getPCACoeff(instanceFeatures, numPCA);
        this.pcaVec = pca.getPCA(instanceFeatures, numPCA);
        this.pcaFeatures = pca.matrixMultiply(instanceFeatures, this.pcaVec);
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            System.out.println("PCA Features Hash: " + ArrayMathOps.matlabHashCode(this.pcaFeatures));
        }
    }

    @Override
    public double[][] getPrePCAInstanceFeatures() {
        return this.prePCAInstanceFeatures;
    }

    @Override
    public double[][] getPCAVectors() {
        return this.pcaVec;
    }

    @Override
    public double[] getPCACoefficients() {
        return this.pcaCoeff;
    }

    @Override
    public int[] getDataRichIndexes() {
        return this.sub;
    }

    @Override
    public double[] getMeans() {
        return this.means;
    }

    @Override
    public double[] getStdDev() {
        return this.stdDev;
    }

    @Override
    public double[][] getPCAFeatures() {
        return this.pcaFeatures;
    }

    @Override
    public double[][] getConfigs() {
        return this.configs;
    }

    @Override
    public double[] getResponseValues() {
        return this.responseValues;
    }

    @Override
    public int[] getCategoricalSize() {
        return this.configSpace.getCategoricalSize();
    }

    @Override
    public int[][] getCondParents() {
        return this.configSpace.getCondParentsArray();
    }

    @Override
    public int[][][] getCondParentVals() {
        return this.configSpace.getCondParentValsArray();
    }

    @Override
    public double transformResponseValue(double d) {
        if (this.logModel) {
            return Math.log10(Math.max(d, 0.005));
        }
        return d;
    }

    @Override
    public int[][] getThetaInstIdxs() {
        int[][] theta_inst_idxs = new int[this.theta_inst_idxs.length][0];
        for (int i = 0; i < theta_inst_idxs.length; ++i) {
            theta_inst_idxs[i] = (int[])this.theta_inst_idxs[i].clone();
        }
        return theta_inst_idxs;
    }

    @Override
    public boolean[] getCensoredResponses() {
        return this.censoredResponseValues;
    }
}

