/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.runhistory;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runhistory.KeyObjectManager;
import ca.ubc.cs.beta.aclib.runhistory.RunData;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.models.fastrf.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRunHistory
implements RunHistory {
    private final InstanceSeedGenerator instanceSeedGenerator;
    private final OverallObjective perInstanceObjectiveFunction;
    private final OverallObjective aggregateInstanceObjectiveFunction;
    private final RunObjective runObj;
    private int iteration = 0;
    private final KeyObjectManager<ParamConfiguration> paramConfigurationList = new KeyObjectManager();
    private final List<RunData> runHistoryList = new ArrayList<RunData>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private double totalRuntimeSum = 0.0;
    private final Map<ParamConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>> configToPerformanceMap = new HashMap<ParamConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>>();
    private final HashMap<ProblemInstance, List<Long>> seedsUsedByInstance = new HashMap();
    private final LinkedHashMap<ParamConfiguration, Integer> configToNumRunsMap = new LinkedHashMap();
    private final HashMap<ParamConfiguration, Set<ProblemInstanceSeedPair>> cappedRuns = new HashMap();
    private Set<ProblemInstance> instancesRanSet = new HashSet<ProblemInstance>();
    private static final DecimalFormat format = new DecimalFormat("#######.####");

    public NewRunHistory(InstanceSeedGenerator instanceSeedGenerator, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj) {
        this.instanceSeedGenerator = instanceSeedGenerator;
        this.perInstanceObjectiveFunction = intraInstanceObjective;
        this.aggregateInstanceObjectiveFunction = interInstanceObjective;
        this.runObj = runObj;
    }

    @Override
    public void append(AlgorithmRun run) throws DuplicateRunException {
        Double dOldValue;
        LinkedHashMap<Long, Double> seedToPerformanceMap;
        this.log.trace("Appending Run {}", (Object)run);
        ParamConfiguration config = run.getRunConfig().getParamConfiguration();
        ProblemInstanceSeedPair pisp = run.getRunConfig().getProblemInstanceSeedPair();
        ProblemInstance pi = pisp.getInstance();
        long seed = run.getResultSeed();
        Double runResult = this.runObj.getObjective(run);
        List<Long> instanceSeedList = this.seedsUsedByInstance.get(pi);
        if (instanceSeedList == null) {
            instanceSeedList = new LinkedList<Long>();
            this.seedsUsedByInstance.put(pi, instanceSeedList);
        }
        instanceSeedList.add(seed);
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceToPerformanceMap == null) {
            instanceToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
            this.configToPerformanceMap.put(config, instanceToPerformanceMap);
        }
        if ((seedToPerformanceMap = instanceToPerformanceMap.get(pi)) == null) {
            seedToPerformanceMap = new LinkedHashMap();
            instanceToPerformanceMap.put(pi, seedToPerformanceMap);
        }
        if ((dOldValue = seedToPerformanceMap.put(seed, runResult)) != null) {
            Set<ProblemInstanceSeedPair> cappedRunsForConfig = this.cappedRuns.get(config);
            if (cappedRunsForConfig != null && cappedRunsForConfig.contains(pisp)) {
                cappedRunsForConfig.remove(pisp);
            } else {
                Object[] args = new Object[]{run, config, pi, dOldValue};
                this.log.error("RunHistory already contains a run with identical config, instance and seed\nRun:{}\nConfig:{}\nInstance:{}\nPrevious Performance:{}", args);
                throw new DuplicateRunException("Duplicate Run Detected", run);
            }
        }
        this.totalRuntimeSum += Math.max(0.1, run.getRuntime());
        int thetaIdx = this.paramConfigurationList.getOrCreateKey(config);
        int instanceIdx = pi.getInstanceID();
        this.runHistoryList.add(new RunData(this.iteration, thetaIdx, instanceIdx, run, runResult, run.getRunResult().equals((Object)RunResult.TIMEOUT) && run.getRunConfig().hasCutoffLessThanMax()));
        if (this.configToNumRunsMap.get(config) == null) {
            this.configToNumRunsMap.put(config, 1);
        } else {
            this.configToNumRunsMap.put(config, this.configToNumRunsMap.get(config) + 1);
        }
        this.instancesRanSet.add(pi);
        if (run.getRunResult().equals((Object)RunResult.TIMEOUT) && run.getRunConfig().hasCutoffLessThanMax()) {
            if (!this.cappedRuns.containsKey(config)) {
                this.cappedRuns.put(config, new LinkedHashSet());
            }
            this.cappedRuns.get(config).add(pisp);
        }
        Object[] args = new Object[]{this.iteration, this.paramConfigurationList.getKey(config), pi.getInstanceID(), pisp.getSeed(), format.format(run.getRunConfig().getCutoffTime())};
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            this.log.debug("Iteration {}: running config {} on instance {} with seed {} and captime {}", args);
        }
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo, minimumResponseValue);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, Double.NEGATIVE_INFINITY);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        if (!this.configToPerformanceMap.containsKey(config) && hallucinatedValues.isEmpty()) {
            return Double.MAX_VALUE;
        }
        ArrayList<Double> instanceCosts = new ArrayList<Double>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceSeedToPerformanceMap == null) {
            instanceSeedToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
        }
        HashSet<ProblemInstance> instancesToUse = new HashSet<ProblemInstance>();
        instancesToUse.addAll(instanceSet);
        HashSet<ProblemInstance> instancesToKeep = new HashSet<ProblemInstance>(instanceSeedToPerformanceMap.keySet());
        instancesToKeep.addAll(hallucinatedValues.keySet());
        instancesToUse.retainAll(instancesToKeep);
        for (ProblemInstance pi : instancesToUse) {
            HashMap<Long, Double> seedToPerformanceMap = new HashMap<Long, Double>();
            if (instanceSeedToPerformanceMap.get(pi) != null) {
                seedToPerformanceMap.putAll((Map)instanceSeedToPerformanceMap.get(pi));
            }
            if (hallucinatedValues.get(pi) != null) {
                seedToPerformanceMap.putAll(hallucinatedValues.get(pi));
            }
            ArrayList<Double> localCosts = new ArrayList<Double>();
            for (Map.Entry ent : seedToPerformanceMap.entrySet()) {
                localCosts.add(Math.max(minimumResponseValue, (Double)ent.getValue()));
            }
            instanceCosts.add(this.perInstanceObjectiveFunction.aggregate(localCosts, cutoffTime));
        }
        return this.aggregateInstanceObjectiveFunction.aggregate(instanceCosts, cutoffTime);
    }

    @Override
    public double getEmpiricalPISPCost(ParamConfiguration config, Set<ProblemInstanceSeedPair> instanceSet, double cutoffTime) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalPISPCost(config, instanceSet, cutoffTime, foo);
    }

    @Override
    public double getEmpiricalPISPCost(ParamConfiguration config, Set<ProblemInstanceSeedPair> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        if (!this.configToPerformanceMap.containsKey(config) && hallucinatedValues.isEmpty()) {
            return Double.MAX_VALUE;
        }
        ArrayList<Double> instanceCosts = new ArrayList<Double>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceSeedToPerformanceMap == null) {
            instanceSeedToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
        }
        HashSet<ProblemInstanceSeedPair> instancesToUse = new HashSet<ProblemInstanceSeedPair>();
        instancesToUse.addAll(instanceSet);
        HashSet<ProblemInstanceSeedPair> instancesToKeep = new HashSet<ProblemInstanceSeedPair>();
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> realValue : instanceSeedToPerformanceMap.entrySet()) {
            for (Long l : realValue.getValue().keySet()) {
                instancesToKeep.add(new ProblemInstanceSeedPair(realValue.getKey(), l));
            }
        }
        for (Map.Entry<ProblemInstance, Map<Long, Double>> halVal : hallucinatedValues.entrySet()) {
            for (Long l : halVal.getValue().keySet()) {
                instancesToKeep.add(new ProblemInstanceSeedPair(halVal.getKey(), l));
            }
        }
        instancesToUse.retainAll(instancesToKeep);
        HashMap organizedPispsToUse = new HashMap();
        for (ProblemInstanceSeedPair problemInstanceSeedPair : instancesToUse) {
            if (organizedPispsToUse.get(problemInstanceSeedPair.getInstance()) == null) {
                organizedPispsToUse.put(problemInstanceSeedPair.getInstance(), new LinkedList());
            }
            ((List)organizedPispsToUse.get(problemInstanceSeedPair.getInstance())).add(problemInstanceSeedPair);
        }
        for (Map.Entry entry : organizedPispsToUse.entrySet()) {
            ProblemInstance pi = (ProblemInstance)entry.getKey();
            HashMap<Long, Double> seedToPerformanceMap = new HashMap<Long, Double>();
            if (instanceSeedToPerformanceMap.get(pi) != null) {
                seedToPerformanceMap.putAll((Map)instanceSeedToPerformanceMap.get(pi));
            }
            if (hallucinatedValues.get(pi) != null) {
                seedToPerformanceMap.putAll(hallucinatedValues.get(pi));
            }
            ArrayList<Double> localCosts = new ArrayList<Double>();
            for (Map.Entry ent : seedToPerformanceMap.entrySet()) {
                if (!((List)entry.getValue()).contains(new ProblemInstanceSeedPair(pi, (Long)ent.getKey()))) continue;
                localCosts.add((Double)ent.getValue());
            }
            instanceCosts.add(this.perInstanceObjectiveFunction.aggregate(localCosts, cutoffTime));
        }
        return this.aggregateInstanceObjectiveFunction.aggregate(instanceCosts, cutoffTime);
    }

    @Override
    public RunObjective getRunObjective() {
        return this.runObj;
    }

    @Override
    public OverallObjective getOverallObjective() {
        return this.perInstanceObjectiveFunction;
    }

    @Override
    public void incrementIteration() {
        ++this.iteration;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Set<ProblemInstance> getInstancesRan(ParamConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstance>();
        }
        return new HashSet<ProblemInstance>(this.configToPerformanceMap.get(config).keySet());
    }

    @Override
    public Set<ProblemInstanceSeedPair> getAlgorithmInstanceSeedPairsRan(ParamConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstanceSeedPair>();
        }
        HashSet<ProblemInstanceSeedPair> pispSet = new HashSet<ProblemInstanceSeedPair>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> kv : instanceSeedToPerformanceMap.entrySet()) {
            ProblemInstance pi = kv.getKey();
            Map hConfigInst = kv.getValue();
            for (Long seed : hConfigInst.keySet()) {
                pispSet.add(new ProblemInstanceSeedPair(pi, seed));
            }
        }
        return pispSet;
    }

    @Override
    public Set<ProblemInstanceSeedPair> getCappedAlgorithmInstanceSeedPairs(ParamConfiguration config) {
        if (!this.cappedRuns.containsKey(config)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.cappedRuns.get(config));
    }

    @Override
    public ProblemInstance getRandomInstanceWithFewestRunsFor(ParamConfiguration config, List<ProblemInstance> instanceList, Random rand) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        ArrayList<ProblemInstance> candidates = new ArrayList<ProblemInstance>(instanceList.size());
        candidates.addAll(instanceList);
        if (this.configToPerformanceMap.containsKey(config)) {
            candidates.removeAll(instanceSeedToPerformanceMap.keySet());
        }
        if (candidates.size() == 0) {
            int minNumRuns = Integer.MAX_VALUE;
            for (ProblemInstance inst : instanceList) {
                int numRuns = instanceSeedToPerformanceMap.get(inst).size();
                if (numRuns > minNumRuns) continue;
                if (numRuns < minNumRuns) {
                    candidates.clear();
                    minNumRuns = numRuns;
                }
                candidates.add(inst);
            }
        }
        int candidateIdx = rand.nextInt(candidates.size());
        this.log.trace("Selected Instance {}", candidates.get(candidateIdx));
        return (ProblemInstance)candidates.get(candidateIdx);
    }

    @Override
    public ProblemInstanceSeedPair getRandomInstanceSeedWithFewestRunsFor(ParamConfiguration config, List<ProblemInstance> instanceList, Random rand) {
        ProblemInstance pi = this.getRandomInstanceWithFewestRunsFor(config, instanceList, rand);
        if (this.seedsUsedByInstance.get(pi) == null) {
            this.seedsUsedByInstance.put(pi, new ArrayList());
        }
        List<Long> seedsUsedByPi = this.seedsUsedByInstance.get(pi);
        Set<Object> seedsUsedByPiConfigSet = this.configToPerformanceMap.get(config) == null || this.configToPerformanceMap.get(config).get(pi) == null ? Collections.emptySet() : this.configToPerformanceMap.get(config).get(pi).keySet();
        ArrayList<Long> seedsUsedByPiConfig = new ArrayList<Long>(seedsUsedByPiConfigSet.size());
        for (Long seed : seedsUsedByPiConfigSet) {
            seedsUsedByPiConfig.add(seed);
        }
        ArrayList<Long> potentialSeeds = new ArrayList<Long>(seedsUsedByPi.size() - seedsUsedByPiConfig.size());
        potentialSeeds.addAll(seedsUsedByPi);
        potentialSeeds.removeAll(seedsUsedByPiConfig);
        long seed = potentialSeeds.size() == 0 ? (long)this.instanceSeedGenerator.getNextSeed(pi) : (Long)potentialSeeds.get(rand.nextInt(potentialSeeds.size()));
        ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
        this.log.trace("New Problem Instance Seed Pair Selected {}", (Object)pisp);
        return pisp;
    }

    @Override
    public int getTotalNumRunsOfConfig(ParamConfiguration config) {
        Integer value = this.configToNumRunsMap.get(config);
        if (value != null) {
            return value;
        }
        return 0;
    }

    @Override
    public double getTotalRunCost() {
        return this.totalRuntimeSum;
    }

    @Override
    public double[] getRunResponseValues() {
        double[] responseValues = new double[this.runHistoryList.size()];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            responseValues[i] = runData.getResponseValue();
            ++i;
        }
        return responseValues;
    }

    @Override
    public boolean[] getCensoredFlagForRuns() {
        boolean[] responseValues = new boolean[this.runHistoryList.size()];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            responseValues[i] = runData.getRun().getRunResult().equals((Object)RunResult.TIMEOUT) && runData.getRun().getRunConfig().hasCutoffLessThanMax();
            ++i;
        }
        return responseValues;
    }

    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        return Collections.unmodifiableSet(this.instancesRanSet);
    }

    @Override
    public Set<ParamConfiguration> getUniqueParamConfigurations() {
        return Collections.unmodifiableSet(this.configToNumRunsMap.keySet());
    }

    @Override
    public int[][] getParameterConfigurationInstancesRanByIndex() {
        int[][] result = new int[this.runHistoryList.size()][2];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            result[i][0] = runData.getThetaIdx();
            result[i][1] = runData.getInstanceidx();
            ++i;
        }
        return result;
    }

    @Override
    public List<ParamConfiguration> getAllParameterConfigurationsRan() {
        ArrayList<ParamConfiguration> runs = new ArrayList<ParamConfiguration>(this.paramConfigurationList.size());
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            runs.add(this.paramConfigurationList.getValue(i));
        }
        return runs;
    }

    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        double[][] configs = new double[this.paramConfigurationList.size()][];
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            configs[i - 1] = this.paramConfigurationList.getValue(i).toValueArray();
        }
        return configs;
    }

    @Override
    public List<AlgorithmRun> getAlgorithmRuns() {
        ArrayList<AlgorithmRun> runs = new ArrayList<AlgorithmRun>(this.runHistoryList.size());
        for (RunData runData : this.getAlgorithmRunData()) {
            runs.add(runData.getRun());
        }
        return runs;
    }

    @Override
    public List<RunData> getAlgorithmRunData() {
        return Collections.unmodifiableList(this.runHistoryList);
    }

    @Override
    public InstanceSeedGenerator getInstanceSeedGenerator() {
        return this.instanceSeedGenerator;
    }

    @Override
    public int getThetaIdx(ParamConfiguration config) {
        return this.paramConfigurationList.getOrCreateKey(config);
    }

    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParamConfiguration config) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> runs = this.configToPerformanceMap.get(config);
        int total = 0;
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> ent : runs.entrySet()) {
            total += ent.getValue().size();
        }
        return total;
    }
}

