/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.seedgenerator;

import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ec.util.MersenneTwister;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomInstanceSeedGenerator
implements InstanceSeedGenerator {
    private static final long serialVersionUID = -5545604876585367506L;
    private final HashMap<Integer, Random> randomPool;
    private final HashMap<Integer, Set<Integer>> usedSeeds;
    private static final transient Logger log = LoggerFactory.getLogger(RandomInstanceSeedGenerator.class);
    private long nextSeed;
    private final long initialSeed;
    private final int initialNumberOfInstances;
    private final int maxSeedsPerInstance;

    public RandomInstanceSeedGenerator(List<ProblemInstance> instances, long seed) {
        this(instances.size(), seed);
    }

    public RandomInstanceSeedGenerator(int numberOfInstances, long seed) {
        this(numberOfInstances, seed, Integer.MAX_VALUE);
    }

    public RandomInstanceSeedGenerator(int numberOfInstances, long seed, int maxSeedsPerInstance) {
        this.maxSeedsPerInstance = maxSeedsPerInstance = Math.abs(maxSeedsPerInstance);
        log.debug("Initializing Instance Seed PRNG with Seed {} and {} allowed seeds", (Object)seed, (Object)maxSeedsPerInstance);
        this.randomPool = new HashMap();
        this.usedSeeds = new HashMap();
        this.initialSeed = seed;
        this.initialNumberOfInstances = numberOfInstances;
        this.reinit();
    }

    @Override
    public void reinit() {
        log.debug("Re-Initializing Instance Seed PRNG with Seed {} and instances {} ", (Object)this.initialSeed, (Object)this.initialNumberOfInstances);
        this.nextSeed = this.initialSeed;
        this.randomPool.clear();
        this.usedSeeds.clear();
        for (int i = 0; i < this.initialNumberOfInstances; ++i) {
            this.randomPool.put(i, new MersenneTwister(this.nextSeed++));
            this.usedSeeds.put(i, new HashSet());
        }
    }

    @Override
    public int getNextSeed(ProblemInstance pi) {
        if (this.hasNextSeed(pi)) {
            return this.getNextSeed(pi.getInstanceID() - 1);
        }
        throw new IllegalStateException("No more Seeds for Problem Instance: " + pi.getInstanceName());
    }

    @Override
    public int getNextSeed(Integer id) {
        Random r = this.randomPool.get(id);
        if (r == null) {
            log.warn("Received ID that I haven't seed before: {}", (Object)id);
            r = new MersenneTwister(this.nextSeed++);
            this.randomPool.put(id, r);
            this.usedSeeds.put(id, new HashSet());
        }
        Set<Integer> generatedSeeds = this.usedSeeds.get(id);
        int i = 0;
        while (!generatedSeeds.add(i = r.nextInt(0x1000000))) {
        }
        return i;
    }

    @Override
    public boolean hasNextSeed(ProblemInstance pi) {
        if (this.usedSeeds.get(pi.getInstanceID() - 1) == null) {
            return 1 <= this.maxSeedsPerInstance;
        }
        return this.usedSeeds.get(pi.getInstanceID() - 1).size() < this.maxSeedsPerInstance;
    }

    @Override
    public List<ProblemInstance> getProblemInstanceOrder(Collection<ProblemInstance> instances) {
        TreeMap<Integer, ProblemInstance> instanceMap = new TreeMap<Integer, ProblemInstance>();
        for (ProblemInstance pi : instances) {
            instanceMap.put(pi.getInstanceID(), pi);
        }
        ArrayList<ProblemInstance> instanceList = new ArrayList<ProblemInstance>();
        instanceList.addAll(instanceMap.values());
        return instanceList;
    }

    @Override
    public int getInitialInstanceSeedCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean allInstancesHaveSameNumberOfSeeds() {
        return true;
    }
}

