/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.AutomaticConfiguratorFactory;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluator;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean concurrentExecution;

    public CommandLineTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig) {
        this(execConfig, true);
    }

    public CommandLineTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, boolean concurrentExecution) {
        super(execConfig);
        this.log.debug("Initalized with the following Execution Configuration {} ", (Object)execConfig);
        this.concurrentExecution = concurrentExecution;
        this.log.debug("Concurrent Execution {}", (Object)concurrentExecution);
        File execDir = new File(execConfig.getAlgorithmExecutionDirectory());
        if (!execDir.exists()) {
            throw new ParameterException("The Algorithm Execution Directory does not exist (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
        if (!execDir.isDirectory()) {
            throw new ParameterException("The Algorithm Execution Directory is NOT a directory (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.evaluateRun(Collections.singletonList(run));
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        AlgorithmRunner runner = this.getAlgorithmRunner(runConfigs);
        List<AlgorithmRun> runs = runner.run();
        this.addRuns(runs);
        return runs;
    }

    private AlgorithmRunner getAlgorithmRunner(List<RunConfig> runConfigs) {
        if (this.concurrentExecution) {
            this.log.info("Using concurrent algorithm runner");
            return AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner(this.execConfig, runConfigs);
        }
        this.log.info("Using single-threaded algorithm runner");
        return AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner(this.execConfig, runConfigs);
    }

    @Override
    public void notifyShutdown() {
    }
}

