/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingCheckerTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private double runtimeDeltaToRequireLogging = 1.0;
    private double wallClockDeltaToRequireLogging;
    private double totalWallClockOverhead = 0.0;
    private double totalRuntimeOverhead = 0.0;
    private static Logger log = LoggerFactory.getLogger(TimingCheckerTargetAlgorithmEvaluator.class);

    public TimingCheckerTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, TargetAlgorithmEvaluator tae) {
        super(tae);
        this.wallClockDeltaToRequireLogging = Math.min(1.5 * execConfig.getAlgorithmCutoffTime(), 10.0);
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.tae.evaluateRun(Collections.singletonList(run));
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs);
        for (AlgorithmRun run : runs) {
            double runtimeOverhead = run.getRuntime() - run.getRunConfig().getCutoffTime();
            this.totalRuntimeOverhead += Math.max(runtimeOverhead, 0.0);
            if (runtimeOverhead > this.runtimeDeltaToRequireLogging) {
                this.runtimeDeltaToRequireLogging = runtimeOverhead + 1.0;
                log.warn("Algorithm has exceeded allowed runtime by {} seconds, next warning at: {} ", (Object)runtimeOverhead, (Object)this.runtimeDeltaToRequireLogging);
            }
            double wallClockOverhead = run.getWallclockExecutionTime() - run.getRunConfig().getCutoffTime();
            this.totalWallClockOverhead += Math.max(wallClockOverhead, 0.0);
            if (!(wallClockOverhead > this.wallClockDeltaToRequireLogging)) continue;
            this.wallClockDeltaToRequireLogging = wallClockOverhead + 1.0;
            log.warn("Algorithm has exceeded allowed wallclock time by {} seconds, next warning at: {} ", (Object)wallClockOverhead, (Object)this.wallClockDeltaToRequireLogging);
        }
        return runs;
    }

    @Override
    public void notifyShutdown() {
        log.info("Total Runtime Overhead: {} seconds", (Object)this.totalRuntimeOverhead);
        log.info("Total wallclock Overhead: {} seconds", (Object)this.totalWallClockOverhead);
        this.tae.notifyShutdown();
    }
}

