/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.random;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomResponseTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluator {
    private double scale = 1.0;
    private boolean sleep = false;
    private double maxValue = 0.0;
    private static final Logger log = LoggerFactory.getLogger(RandomResponseTargetAlgorithmEvaluator.class);

    public RandomResponseTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig) {
        super(execConfig);
        try {
            this.scale = Math.abs(Double.valueOf(execConfig.getAlgorithmExecutable()));
        }
        catch (NumberFormatException e) {
            this.scale = 10.0;
        }
        this.sleep = execConfig.isDeterministicAlgorithm();
        this.maxValue = execConfig.getAlgorithmCutoffTime();
    }

    @Override
    public void notifyShutdown() {
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        Random rand = SeedableRandomSingleton.getRandom();
        ArrayList<AlgorithmRun> ar = new ArrayList<AlgorithmRun>(runConfigs.size());
        for (RunConfig rc : runConfigs) {
            double time = rand.nextDouble() * this.maxValue;
            if (time >= rc.getCutoffTime()) {
                ar.add(new ExistingAlgorithmRun(this.execConfig, rc, "TIMEOUT," + rc.getCutoffTime() + ",-1,0," + rc.getProblemInstanceSeedPair().getSeed()));
                continue;
            }
            ar.add(new ExistingAlgorithmRun(this.execConfig, rc, "SAT, " + time + ",-1,0," + rc.getProblemInstanceSeedPair().getSeed()));
        }
        return ar;
    }
}

