/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class CauchyDistribution
extends ContinuousDistribution {
    private double median;
    private double scale;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double m, double s) {
        this.setMedian(m);
        this.setScale(s);
    }

    public double cumulativeProbability(double x) {
        double ret = Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? (x < 0.0 ? 0.0 : 1.0) : (x == this.median ? 0.5 : 0.5 + Math.atan((x - this.median) / this.scale) / Math.PI));
        return ret;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCumulativeProbability(double p) {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : (p == 0.5 ? this.median : this.median + this.scale * Math.tan(Math.PI * (p - 0.5)))));
        return ret;
    }

    public void setMedian(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("location parameter must be a valid number.");
        }
        this.median = m;
    }

    public void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale parameter must be positive.");
        }
        this.scale = s;
    }
}

