/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.expectedimprovement.ExpectedImprovementFunction;
import ca.ubc.cs.beta.aclib.misc.associatedvalue.ParamWithEI;
import ca.ubc.cs.beta.aclib.misc.math.ArrayMathOps;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.model.builder.AdaptiveCappingModelBuilder;
import ca.ubc.cs.beta.aclib.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aclib.model.data.MaskCensoredDataAsUncensored;
import ca.ubc.cs.beta.aclib.model.data.MaskInactiveConditionalParametersWithDefaults;
import ca.ubc.cs.beta.aclib.model.data.PCAModelDataSanitizer;
import ca.ubc.cs.beta.aclib.model.data.SanitizedModelData;
import ca.ubc.cs.beta.aclib.options.SMACOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.RoundingMode;
import ca.ubc.cs.beta.smac.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.matlab.helper.StaticMethodWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialModelBasedAlgorithmConfiguration
extends AbstractAlgorithmFramework {
    private final int numPCA;
    private final boolean logModel;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SMACOptions smacConfig;
    private RandomForest forest;
    private RandomForest preparedForest;
    private SanitizedModelData sanitizedData;
    private final ExpectedImprovementFunction ei;
    private static final boolean SELECT_CONFIGURATION_SYNC_DEBUGGING = false;
    private double subsamplePercentage = 1.0;
    StaticMethodWrapper smw = new StaticMethodWrapper();

    public SequentialModelBasedAlgorithmConfiguration(SMACOptions smacConfig, List<ProblemInstance> instances, List<ProblemInstance> testInstances, TargetAlgorithmEvaluator algoEval, ExpectedImprovementFunction ei, StateFactory sf, ParamConfigurationSpace configSpace, InstanceSeedGenerator instanceSeedGen, Random rand, ParamConfiguration initialConfiguration) {
        super(smacConfig, instances, testInstances, algoEval, sf, configSpace, instanceSeedGen, rand, initialConfiguration);
        this.numPCA = smacConfig.numPCA;
        this.logModel = smacConfig.randomForestOptions.logModel;
        this.smacConfig = smacConfig;
        this.ei = ei;
    }

    protected double freeMemoryAfterGC() {
        this.log.debug("Running System Garbage Collector");
        System.gc();
        double freeMemory = (double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().totalMemory();
        this.log.debug("Free memory {} %", (Object)freeMemory);
        return freeMemory;
    }

    @Override
    protected void learnModel(RunHistory runHistory, ParamConfigurationSpace configSpace) {
        if (this.options.randomForestOptions.subsampleValuesWhenLowMemory) {
            double freeMemory = this.freeMemoryAfterGC();
            if (freeMemory < this.options.randomForestOptions.freeMemoryPercentageToSubsample) {
                this.subsamplePercentage *= this.options.randomForestOptions.subsamplePercentage;
                Object[] args = new Object[]{this.getIteration(), freeMemory, this.subsamplePercentage};
                this.log.info("Iteration {} : Free memory too low ({}) subsample percentage now {} ", args);
            }
        } else {
            this.subsamplePercentage = 1.0;
        }
        LinkedHashSet all_instances = new LinkedHashSet(this.instances);
        Set paramConfigs = runHistory.getUniqueParamConfigurations();
        Set runInstances = runHistory.getUniqueInstancesRan();
        ArrayList<Integer> runInstancesIdx = new ArrayList<Integer>(all_instances.size());
        int i = 0;
        double[][] instanceFeatureMatrix = new double[all_instances.size()][];
        for (ProblemInstance pi : all_instances) {
            if (runInstances.contains(pi)) {
                runInstancesIdx.add(i);
            }
            instanceFeatureMatrix[i] = pi.getFeaturesDouble();
            ++i;
        }
        double[][] thetaMatrix = new double[paramConfigs.size()][];
        i = 0;
        for (ParamConfiguration pc : paramConfigs) {
            if (this.smacConfig.maskInactiveConditionalParametersAsDefaultValue) {
                thetaMatrix[i++] = pc.toComparisonValueArray();
                continue;
            }
            thetaMatrix[i++] = pc.toValueArray();
        }
        int[] usedInstanceIdxs = new int[runInstancesIdx.size()];
        for (int j = 0; j < runInstancesIdx.size(); ++j) {
            usedInstanceIdxs[j] = (Integer)runInstancesIdx.get(j);
        }
        double[] runResponseValues = runHistory.getRunResponseValues();
        for (int j = 0; j < runResponseValues.length; ++j) {
            if (!(runResponseValues[j] >= this.options.scenarioConfig.cutoffTime)) continue;
            runResponseValues[j] = this.options.scenarioConfig.cutoffTime * this.options.scenarioConfig.intraInstanceObj.getPenaltyFactor();
        }
        this.sanitizedData = new PCAModelDataSanitizer((double[][])instanceFeatureMatrix, (double[][])thetaMatrix, this.numPCA, runResponseValues, usedInstanceIdxs, this.logModel, runHistory.getParameterConfigurationInstancesRanByIndex(), runHistory.getCensoredFlagForRuns(), configSpace);
        if (this.smacConfig.maskCensoredDataAsUncensored) {
            this.sanitizedData = new MaskCensoredDataAsUncensored(this.sanitizedData);
        }
        if (this.smacConfig.maskInactiveConditionalParametersAsDefaultValue) {
            this.sanitizedData = new MaskInactiveConditionalParametersWithDefaults(this.sanitizedData, configSpace);
        }
        this.forest = null;
        this.preparedForest = null;
        Object mb = this.options.adaptiveCapping != false ? new AdaptiveCappingModelBuilder(this.sanitizedData, this.smacConfig.randomForestOptions, this.rand, this.smacConfig.imputationIterations, this.smacConfig.scenarioConfig.cutoffTime, this.smacConfig.scenarioConfig.intraInstanceObj.getPenaltyFactor(), this.subsamplePercentage) : new BasicModelBuilder(this.sanitizedData, this.smacConfig.randomForestOptions, this.subsamplePercentage);
        this.forest = mb.getRandomForest();
        this.preparedForest = mb.getPreparedRandomForest();
        this.log.info("Random Forest Built");
    }

    @Override
    protected List<ParamConfiguration> selectConfigurations() {
        AutoStartStopWatch t = new AutoStartStopWatch();
        List<ParamConfiguration> eichallengers = this.selectChallengersWithEI(this.smacConfig.numberOfChallengers);
        this.log.info("Selecting {} challengers based on EI took {} seconds", (Object)eichallengers.size(), (Object)((double)t.stop() / 1000.0));
        ArrayList<ParamConfiguration> randomChallengers = new ArrayList<ParamConfiguration>(eichallengers.size());
        t = new AutoStartStopWatch();
        for (int i = 0; i < eichallengers.size(); ++i) {
            randomChallengers.add(this.configSpace.getRandomConfiguration());
        }
        this.log.debug("Generating {} Random Configurations took {} seconds", (Object)eichallengers.size(), (Object)((double)t.stop() / 1000.0));
        ArrayList<ParamConfiguration> challengers = new ArrayList<ParamConfiguration>(eichallengers.size() * 2);
        for (int i = 0; i < eichallengers.size(); ++i) {
            challengers.add(eichallengers.get(i));
            challengers.add((ParamConfiguration)randomChallengers.get(i));
        }
        double[][] configArrayToDebug = new double[challengers.size()][];
        int j = 0;
        for (ParamConfiguration c : challengers) {
            configArrayToDebug[j++] = c.toValueArray();
        }
        return challengers;
    }

    public List<ParamConfiguration> selectChallengersWithEI(int numChallengers) {
        HashSet instanceSet = new HashSet();
        instanceSet.addAll(this.runHistory.getInstancesRan(this.incumbent));
        List paramConfigs = this.runHistory.getAllParameterConfigurationsRan();
        double[][] predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(paramConfigs));
        double[] predmean = predictions[0];
        double[] predvar = predictions[1];
        double[][] tmp_predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(Collections.singletonList(this.incumbent)));
        this.log.info("Prediction for incumbent: {} +/- {} (in log space if logModel=true)", (Object)tmp_predictions[0][0], (Object)tmp_predictions[1][0]);
        double fmin = this.runHistory.getEmpiricalCost(this.incumbent, instanceSet, this.smacConfig.scenarioConfig.cutoffTime);
        if (this.smacConfig.randomForestOptions.logModel) {
            fmin = Math.max(0.005, fmin);
            fmin = Math.log10(fmin);
            double adjusted_fmin = this.runHistory.getEmpiricalCost(this.incumbent, instanceSet, this.smacConfig.scenarioConfig.cutoffTime, 0.005);
            adjusted_fmin = Math.max(0.005, adjusted_fmin);
            adjusted_fmin = Math.log10(adjusted_fmin);
            Object[] args = new Object[]{this.getIteration(), fmin, adjusted_fmin};
            this.log.info("Optimizing EI at valdata.iteration {}. fmin: {}, fmin (accounting for minimum response value): {}", args);
        } else {
            this.log.info("Optimizing EI at valdata.iteration {}. fmin: {}", (Object)this.getIteration(), (Object)fmin);
        }
        AutoStartStopWatch watch = new AutoStartStopWatch();
        double[] negativeExpectedImprovementOfTheta = this.ei.computeNegativeExpectedImprovement(fmin, predmean, predvar);
        watch.stop();
        this.log.info("Compute negEI for all conf. seen at valdata.iteration {}: took {} s", (Object)this.getIteration(), (Object)((double)watch.time() / 1000.0));
        LinkedHashMap<Object, double[]> configPredMeanVarEIMap = new LinkedHashMap<Object, double[]>();
        for (int i = 0; i < paramConfigs.size(); ++i) {
            double[] val = new double[]{predmean[i], predvar[i], negativeExpectedImprovementOfTheta[i]};
            configPredMeanVarEIMap.put(paramConfigs.get(i), val);
        }
        List sortedParams = ParamWithEI.merge((double[])negativeExpectedImprovementOfTheta, (List)paramConfigs);
        Collections.sort(sortedParams);
        int numberOfSearches = Math.min(numChallengers, predmean.length);
        List bestResults = new ArrayList<ParamWithEI>(numberOfSearches);
        double min_neg = Double.MAX_VALUE;
        AutoStartStopWatch stpWatch = new AutoStartStopWatch();
        for (int i = 0; i < numberOfSearches; ++i) {
            watch = new AutoStartStopWatch();
            ParamWithEI lsResult = this.localSearch((ParamWithEI)sortedParams.get(i), fmin, Math.pow(10.0, -5.0));
            if ((Double)lsResult.getAssociatedValue() < min_neg) {
                min_neg = (Double)lsResult.getAssociatedValue();
            }
            predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(Collections.singletonList(lsResult.getValue())));
            double[] val = new double[]{predictions[0][0], predictions[1][0], (Double)lsResult.getAssociatedValue()};
            bestResults.add(lsResult);
            configPredMeanVarEIMap.put(lsResult.getValue(), val);
            watch.stop();
            Object[] args = new Object[]{i + 1, (double)watch.time() / 1000.0, min_neg};
            this.log.debug("LS {} took {} seconds and yielded neg log EI {}", args);
        }
        this.log.info("{} Local Searches took {} seconds in total ", (Object)numberOfSearches, (Object)((double)stpWatch.stop() / 1000.0));
        double[][] configArrayToDebug = new double[bestResults.size()][];
        int j = 0;
        for (ParamWithEI bestResult : bestResults) {
            configArrayToDebug[j++] = ((ParamConfiguration)bestResult.getValue()).toValueArray();
        }
        int nextRandom = SeedableRandomSingleton.getRandom().nextInt();
        int numberOfRandomConfigsInEI = this.smacConfig.numberOfRandomConfigsInEI;
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            this.log.warn("Hard coded number of configurations for random to 10");
            numberOfRandomConfigsInEI = 10;
        }
        AutoStartStopWatch t = new AutoStartStopWatch();
        ArrayList<ParamConfiguration> randomConfigs = new ArrayList<ParamConfiguration>(numberOfRandomConfigsInEI);
        for (int i = 0; i < numberOfRandomConfigsInEI; ++i) {
            randomConfigs.add(this.configSpace.getRandomConfiguration());
        }
        this.log.debug("Generating {} Random Configurations took {} (s)", (Object)numberOfRandomConfigsInEI, (Object)((double)t.stop() / 1000.0));
        t = new AutoStartStopWatch();
        double[][] randomConfigToDebug = new double[randomConfigs.size()][];
        for (int i = 0; i < randomConfigs.size(); ++i) {
            randomConfigToDebug[i] = ((ParamConfiguration)randomConfigs.get(i)).toValueArray();
        }
        predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(randomConfigs));
        predmean = predictions[0];
        predvar = predictions[1];
        this.log.debug("Prediction for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
        t = new AutoStartStopWatch();
        double[] expectedImprovementOfRandoms = this.ei.computeNegativeExpectedImprovement(fmin, predmean, predvar);
        this.log.debug("EI Calculation for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
        t = new AutoStartStopWatch();
        for (int i = 0; i < randomConfigs.size(); ++i) {
            double[] val = new double[]{predmean[i], predvar[i], expectedImprovementOfRandoms[i]};
            configPredMeanVarEIMap.put(randomConfigs.get(i), val);
        }
        this.log.debug("Map Insertion for Random Configurations took {} (s)", (Object)((double)t.stop() / 1000.0));
        bestResults.addAll(ParamWithEI.merge((double[])expectedImprovementOfRandoms, randomConfigs));
        configArrayToDebug = new double[bestResults.size()][];
        j = 0;
        for (ParamWithEI eic : bestResults) {
            configArrayToDebug[j++] = ((ParamConfiguration)eic.getValue()).toValueArray();
        }
        if (RoundingMode.ROUND_NUMBERS_FOR_MATLAB_SYNC) {
            ArrayList<ParamWithEI> realBestResults = new ArrayList<ParamWithEI>(bestResults.size());
            for (ParamWithEI paramWithEI : bestResults) {
                double ei = (double)Math.round((Double)paramWithEI.getAssociatedValue() * 1.0E9) / 1.0E9;
                realBestResults.add(new ParamWithEI(Double.valueOf(ei), (ParamConfiguration)paramWithEI.getValue()));
            }
            bestResults = realBestResults;
        }
        bestResults = ArrayMathOps.permute(bestResults);
        Collections.sort(bestResults);
        for (int i = 0; i < numberOfSearches; ++i) {
            double[] meanvar = (double[])configPredMeanVarEIMap.get(((ParamWithEI)bestResults.get(i)).getValue());
            Object[] objectArray = new Object[]{i + 1, meanvar[0], Math.sqrt(meanvar[1]), -meanvar[2]};
            this.log.info("Challenger {} predicted {} +/- {}, expected improvement {}", objectArray);
        }
        ArrayList<Object> results = new ArrayList<Object>(bestResults.size());
        for (ParamWithEI paramWithEI : bestResults) {
            results.add(paramWithEI.getValue());
        }
        configArrayToDebug = new double[results.size()][];
        j = 0;
        for (ParamConfiguration paramConfiguration : results) {
            configArrayToDebug[j++] = paramConfiguration.toValueArray();
        }
        return Collections.unmodifiableList(results);
    }

    private ParamWithEI localSearch(ParamWithEI startEIC, double fmin_sample, double epsilon) {
        ParamWithEI incumbentEIC = startEIC;
        int localSearchSteps = 0;
        while (true) {
            if (++localSearchSteps % 1000 == 0) {
                this.log.warn("Local Search has done {} iterations, possible infinite loop", (Object)localSearchSteps);
            }
            ParamConfiguration c = (ParamConfiguration)incumbentEIC.getValue();
            double currentMinEI = (Double)incumbentEIC.getAssociatedValue();
            double[][] cArray = new double[][]{c.toValueArray()};
            int LSHashCode = ArrayMathOps.matlabHashCode((double[][])cArray);
            List neighbourhood = c.getNeighbourhood();
            double[][] prediction = ArrayMathOps.transpose((double[][])this.applyMarginalModel(neighbourhood));
            double[] means = prediction[0];
            double[] vars = prediction[1];
            double[] eiVal = this.ei.computeNegativeExpectedImprovement(fmin_sample, means, vars);
            double min = eiVal[0];
            for (int i = 1; i < eiVal.length; ++i) {
                if (!(eiVal[i] < min)) continue;
                min = eiVal[i];
            }
            if (min >= currentMinEI - epsilon) break;
            ArrayList<Integer> minIdx = new ArrayList<Integer>(c.size());
            for (int i = 0; i < eiVal.length; ++i) {
                if (!(eiVal[i] <= min + epsilon)) continue;
                minIdx.add(i);
            }
            int nextIdx = (Integer)minIdx.get(SeedableRandomSingleton.getRandom().nextInt(minIdx.size()));
            ParamConfiguration best = (ParamConfiguration)neighbourhood.get(nextIdx);
            incumbentEIC = new ParamWithEI(Double.valueOf(eiVal[nextIdx]), best);
            double[][] next = new double[][]{best.toValueArray()};
            double[][] predictions = ArrayMathOps.transpose((double[][])this.applyMarginalModel(next));
            double[] mean = predictions[0];
            double[] var = predictions[1];
            eiVal = this.ei.computeNegativeExpectedImprovement(fmin_sample, mean, var);
            Object[] args = new Object[]{eiVal[0], mean[0], var[0]};
            this.log.trace("Expected improvement for next step is {} mean={}, var={}", args);
        }
        this.log.debug("Local Search took {} steps", (Object)localSearchSteps);
        return incumbentEIC;
    }

    protected double[][] applyMarginalModel(double[][] configArrays) {
        int[] treeIdxsToUse = new int[this.forest.numTrees];
        for (int i = 0; i < this.forest.numTrees; ++i) {
            treeIdxsToUse[i] = i;
        }
        if (this.smacConfig.randomForestOptions.preprocessMarginal) {
            return RandomForest.applyMarginal((RandomForest)this.preparedForest, (int[])treeIdxsToUse, (double[][])configArrays);
        }
        return RandomForest.applyMarginal((RandomForest)this.forest, (int[])treeIdxsToUse, (double[][])configArrays, (double[][])this.sanitizedData.getPCAFeatures());
    }

    protected double[][] applyMarginalModel(List<ParamConfiguration> configs) {
        double[][] configArrays = new double[configs.size()][];
        int i = 0;
        for (ParamConfiguration config : configs) {
            configArrays[i] = config.toValueArray();
            ++i;
        }
        return this.applyMarginalModel(configArrays);
    }
}

