/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.builder;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.ParamFileHelper;
import ca.ubc.cs.beta.aclib.events.EventManager;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.model.builder.HashCodeVerifyingModelBuilder;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.options.SMACOptions;
import ca.ubc.cs.beta.aclib.options.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceHelper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.smac.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.SequentialModelBasedAlgorithmConfiguration;
import ca.ubc.cs.beta.smac.state.nullFactory.NullStateFactory;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACBuilder {
    private static transient Logger log = LoggerFactory.getLogger(SMACBuilder.class);
    private final EventManager eventManager = new EventManager();
    private List<ProblemInstance> instances = null;
    private InstanceSeedGenerator instanceSeedGen = null;
    private static Pattern modelHashCodePattern = Pattern.compile("^(Preprocessed|Random) Forest Built with Hash Code:\\s*\\d+?\\z");

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setInstances(List<ProblemInstance> instances) {
        this.instances = instances;
    }

    public void setInstanceSeedGenerator(InstanceSeedGenerator insc) {
        this.instanceSeedGen = insc;
    }

    public List<ProblemInstance> getInstances() {
        return this.instances;
    }

    public void setInstancesAndSeedGenFromOptions(SMACOptions options) throws IOException {
        InstanceListWithSeeds ilws = ProblemInstanceHelper.getInstances((String)options.scenarioConfig.instanceFile, (String)options.experimentDir, (String)options.scenarioConfig.instanceFeatureFile, (boolean)options.scenarioConfig.checkInstanceFilesExist, (long)(options.numRun + options.seedOffset + 1L), (boolean)options.scenarioConfig.algoExecOptions.deterministic);
        this.instanceSeedGen = ilws.getSeedGen();
        this.instances = ilws.getInstances();
    }

    public AbstractAlgorithmFramework getSMAC(SMACOptions options, TargetAlgorithmEvaluator tae) {
        AbstractAlgorithmFramework smac;
        NullStateFactory sf;
        String[] possiblePaths;
        NullStateFactory restoreSF;
        SeedableRandomSingleton.setSeed((long)(options.numRun + options.seedOffset));
        Random rand = SeedableRandomSingleton.getRandom();
        if (this.instances == null) {
            throw new IllegalStateException("Instances must be set prior to getting SMAC Object");
        }
        if (this.instanceSeedGen == null) {
            throw new IllegalStateException("InstanceSeedGen must be set prior to getting SMAC Object");
        }
        if (this.instanceSeedGen.allInstancesHaveSameNumberOfSeeds()) {
            throw new ParameterException("All Training Instances must have the same number of seeds in this version of SMAC");
        }
        switch (options.statedeSerializer) {
            case NULL: {
                restoreSF = new NullStateFactory();
                break;
            }
            case LEGACY: {
                restoreSF = new LegacyStateFactory(options.scenarioConfig.outputDirectory + File.separator + options.runGroupName + File.separator + "state-run" + options.numRun + File.separator, options.restoreStateFrom);
                break;
            }
            default: {
                throw new IllegalArgumentException("State Serializer specified is not supported");
            }
        }
        String paramFile = options.scenarioConfig.paramFileDelegate.paramFile;
        log.info("Parsing Parameter Space File", (Object)paramFile);
        ParamConfigurationSpace configSpace = null;
        for (String path : possiblePaths = new String[]{paramFile, options.experimentDir + File.separator + paramFile, options.scenarioConfig.algoExecOptions.algoExecDir + File.separator + paramFile}) {
            try {
                log.debug("Trying param file in path {} ", (Object)path);
                configSpace = ParamFileHelper.getParamFileParser((String)path, (long)(options.numRun + options.seedOffset + 1000000L));
                break;
            }
            catch (IllegalStateException e) {
            }
        }
        if (configSpace == null) {
            throw new ParameterException("Could not find param file");
        }
        String algoExecDir = options.scenarioConfig.algoExecOptions.algoExecDir;
        File f2 = new File(algoExecDir);
        if (!f2.isAbsolute()) {
            f2 = new File(options.experimentDir + File.separator + algoExecDir);
        }
        AlgorithmExecutionConfig execConfig = new AlgorithmExecutionConfig(options.scenarioConfig.algoExecOptions.algoExec, f2.getAbsolutePath(), configSpace, false, options.scenarioConfig.algoExecOptions.deterministic, options.scenarioConfig.cutoffTime);
        switch (options.stateSerializer) {
            case NULL: {
                sf = new NullStateFactory();
                break;
            }
            case LEGACY: {
                String savePath = options.scenarioConfig.outputDirectory + File.separator + options.runGroupName + File.separator + "state-run" + options.numRun + File.separator;
                File saveLocation = new File(savePath);
                if (!saveLocation.isAbsolute()) {
                    savePath = options.experimentDir + File.separator + savePath;
                }
                sf = new LegacyStateFactory(savePath, options.restoreStateFrom);
                break;
            }
            default: {
                throw new IllegalArgumentException("State Serializer specified is not supported");
            }
        }
        TargetAlgorithmEvaluator algoEval = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((ScenarioOptions)options.scenarioConfig, (AlgorithmExecutionConfig)execConfig);
        if (options.modelHashCodeFile != null) {
            log.info("Algorithm Execution will verify model Hash Codes");
            this.parseModelHashCodes(options.modelHashCodeFile);
        }
        switch (options.execMode) {
            case ROAR: {
                smac = new AbstractAlgorithmFramework(options, this.instances, algoEval, (StateFactory)sf, configSpace, this.instanceSeedGen, rand, this.eventManager);
                break;
            }
            case SMAC: {
                smac = new SequentialModelBasedAlgorithmConfiguration(options, this.instances, algoEval, options.expFunc.getFunction(), (StateFactory)sf, configSpace, this.instanceSeedGen, rand, this.eventManager);
                break;
            }
            default: {
                throw new IllegalArgumentException("Execution Mode Specified is not supported");
            }
        }
        if (options.restoreIteration != null) {
            this.restoreState(options, restoreSF, smac, configSpace, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, options.scenarioConfig.runObj, this.instances, execConfig);
        }
        return smac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseModelHashCodes(File modelHashCodeFile) {
        log.info("Model Hash Code File Passed {}", (Object)modelHashCodeFile.getAbsolutePath());
        LinkedList<Integer> modelHashCodeQueue = new LinkedList<Integer>();
        LinkedList<Integer> preprocessedHashCodeQueue = new LinkedList<Integer>();
        BufferedReader bin = null;
        try {
            try {
                String line;
                bin = new BufferedReader(new FileReader(modelHashCodeFile));
                int hashCodeCount = 0;
                int lineCount = 1;
                while ((line = bin.readLine()) != null) {
                    Matcher m = modelHashCodePattern.matcher(line);
                    if (m.find()) {
                        Object[] array = new Object[]{++hashCodeCount, lineCount, line};
                        log.debug("Found Model Hash Code #{} on line #{} with contents:{}", array);
                        boolean preprocessed = line.substring(0, 1).equals("P");
                        int colonIndex = line.indexOf(":");
                        String lineSubStr = line.substring(colonIndex + 1).trim();
                        if (!preprocessed) {
                            modelHashCodeQueue.add(Integer.valueOf(lineSubStr));
                        } else {
                            preprocessedHashCodeQueue.add(Integer.valueOf(lineSubStr));
                        }
                    } else {
                        log.trace("No Hash Code found on line: {}", (Object)line);
                    }
                    ++lineCount;
                }
                if (hashCodeCount == 0) {
                    log.warn("Hash Code File Specified, but we found no hash codes");
                }
            }
            finally {
                if (bin != null) {
                    bin.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashCodeVerifyingModelBuilder.modelHashes = modelHashCodeQueue;
        HashCodeVerifyingModelBuilder.preprocessedHashes = preprocessedHashCodeQueue;
    }

    private void restoreState(SMACOptions options, StateFactory sf, AbstractAlgorithmFramework smac, ParamConfigurationSpace configSpace, OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj, List<ProblemInstance> instances, AlgorithmExecutionConfig execConfig) {
        if (options.restoreIteration < 0) {
            throw new ParameterException("Iteration must be a non-negative integer");
        }
        StateDeserializer sd = sf.getStateDeserializer("it", options.restoreIteration.intValue(), configSpace, intraInstanceObjective, interInstanceObjective, runObj, instances, execConfig);
        smac.restoreState(sd);
    }
}

