/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.ParamFileHelper;
import ca.ubc.cs.beta.aclib.exceptions.FeatureNotFoundException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AlgorithmExecutionOptions;
import ca.ubc.cs.beta.aclib.options.ConfigToLaTeX;
import ca.ubc.cs.beta.aclib.options.ScenarioOptions;
import ca.ubc.cs.beta.aclib.options.ValidationExecutorOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceHelper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileParser;
import ca.ubc.cs.beta.smac.validation.Validator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ValidatorExecutor {
    private static Logger log = LoggerFactory.getLogger(ValidatorExecutor.class);
    private static Marker exception;
    private static Marker stackTrace;

    public static void main(String[] args) {
        ValidationExecutorOptions options = new ValidationExecutorOptions();
        JCommander com = new JCommander((Object)options, true, true);
        com.setProgramName("validate");
        try {
            try {
                File f;
                boolean verifySATCompatible;
                String algoExecDir;
                File f2;
                List<TrajectoryFileEntry> tfes;
                String[] possiblePaths;
                InstanceListWithSeeds ilws;
                com.parse(args);
                log.info("==========Configuration Options==========\n{}", (Object)options.toString());
                VersionTracker.setClassLoader((ClassLoader)TargetAlgorithmEvaluatorBuilder.getClassLoader((AlgorithmExecutionOptions)options.scenarioConfig.algoExecOptions));
                VersionTracker.logVersions();
                if (options.incumbent != null && options.trajectoryFile != null) {
                    throw new ParameterException("You cannot specify both a configuration and a trajectory file");
                }
                if (options.trajectoryFile != null) {
                    log.info("Using Trajectory File {} ", (Object)options.trajectoryFile.getAbsolutePath());
                    if (options.tunerTime == -1.0) {
                        options.tunerTime = options.scenarioConfig.tunerTimeout;
                        log.info("Using Scenario Tuner Time {} seconds", (Object)options.tunerTime);
                    }
                } else {
                    if (options.tunerTime == -1.0) {
                        options.tunerTime = 0.0;
                    }
                    if (options.empericalPerformance == -1.0) {
                        options.empericalPerformance = 0.0;
                    }
                    log.info("Using configuration specified on Command Line");
                }
                log.info("Parsing test instances from {}", (Object)options.scenarioConfig.testInstanceFile);
                String instanceFeatureFile = null;
                instanceFeatureFile = options.scenarioConfig.instanceFeatureFile;
                String instanceFile = options.validateTestInstances ? options.scenarioConfig.testInstanceFile : options.scenarioConfig.instanceFile;
                try {
                    ilws = ProblemInstanceHelper.getInstances((String)instanceFile, (String)options.experimentDir, (String)options.scenarioConfig.instanceFeatureFile, (boolean)options.scenarioConfig.checkInstanceFilesExist, (long)options.seed, (int)Integer.MAX_VALUE);
                }
                catch (FeatureNotFoundException e) {
                    ilws = ProblemInstanceHelper.getInstances((String)instanceFile, (String)options.experimentDir, null, (boolean)options.scenarioConfig.checkInstanceFilesExist, (long)options.seed, (int)Integer.MAX_VALUE);
                }
                List testInstances = ilws.getInstances();
                InstanceSeedGenerator testInstanceSeedGen = ilws.getSeedGen();
                log.info("Parsing Parameter Space File", (Object)options.scenarioConfig.paramFileDelegate.paramFile);
                ParamConfigurationSpace configSpace = null;
                for (String path : possiblePaths = new String[]{options.scenarioConfig.paramFileDelegate.paramFile, options.experimentDir + File.separator + options.scenarioConfig.paramFileDelegate.paramFile, options.scenarioConfig.algoExecOptions.algoExecDir + File.separator + options.scenarioConfig.paramFileDelegate.paramFile}) {
                    try {
                        log.debug("Trying param file in path {} ", (Object)path);
                        configSpace = ParamFileHelper.getParamFileParser((String)path, (long)1234L);
                        break;
                    }
                    catch (IllegalStateException e) {
                    }
                }
                double nearestTunerTime = 0.0;
                if (options.trajectoryFile != null) {
                    tfes = TrajectoryFileParser.parseTrajectoryFileAsList((File)options.trajectoryFile, configSpace);
                    if (options.validationOptions.maxTimestamp == -1.0) {
                        options.validationOptions.maxTimestamp = options.scenarioConfig.tunerTimeout;
                    }
                } else {
                    ParamConfiguration configToValidate;
                    if (options.tunerOverheadTime == -1.0) {
                        options.tunerOverheadTime = 0.0;
                    }
                    if (options.incumbent == null) {
                        log.warn("No configuration supplied");
                        ParamConfiguration configToValidate2 = configSpace.getDefaultConfiguration();
                        log.info("To validate the incumbent please use --configuration \"" + configToValidate2.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX) + "\"");
                        throw new ParameterException("Must supply a configuration to validate");
                    }
                    log.info("Parsing Supplied Configuration");
                    if (options.incumbent.trim().equals("<DEFAULT>")) {
                        configToValidate = configSpace.getDefaultConfiguration();
                    } else {
                        try {
                            configToValidate = configSpace.getConfigurationFromString(options.incumbent, ParamConfiguration.StringFormat.NODB_SYNTAX);
                        }
                        catch (RuntimeException e) {
                            try {
                                log.info("Being nice and checking if this is a STATEFILE encoded configuration");
                                configToValidate = configSpace.getConfigurationFromString(options.incumbent, ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
                            }
                            catch (RuntimeException e2) {
                                throw e;
                            }
                        }
                    }
                    tfes = Collections.singletonList(new TrajectoryFileEntry(configToValidate, options.tunerTime, options.empericalPerformance, options.tunerOverheadTime));
                }
                if (!(f2 = new File(algoExecDir = options.scenarioConfig.algoExecOptions.algoExecDir)).isAbsolute()) {
                    f2 = new File(options.experimentDir + File.separator + algoExecDir);
                }
                AlgorithmExecutionConfig execConfig = new AlgorithmExecutionConfig(options.scenarioConfig.algoExecOptions.algoExec, f2.getAbsolutePath(), configSpace, false, options.scenarioConfig.algoExecOptions.deterministic, options.scenarioConfig.cutoffTime);
                if (options.scenarioConfig.algoExecOptions.verifySAT == null) {
                    verifySATCompatible = ProblemInstanceHelper.isVerifySATCompatible((Collection)testInstances);
                    if (verifySATCompatible) {
                        log.debug("Instance Specific Information is compatible with Verifying SAT, enabling option");
                        options.scenarioConfig.algoExecOptions.verifySAT = true;
                    } else {
                        log.debug("Instance Specific Information is NOT compatible with Verifying SAT, disabling option");
                        options.scenarioConfig.algoExecOptions.verifySAT = false;
                    }
                } else if (options.scenarioConfig.algoExecOptions.verifySAT.booleanValue() && !(verifySATCompatible = ProblemInstanceHelper.isVerifySATCompatible((Collection)testInstances))) {
                    log.warn("Verify SAT set to true, but some instances have instance specific information that isn't in {SAT, SATISFIABLE, UNKNOWN, UNSAT, UNSATISFIABLE}");
                }
                TargetAlgorithmEvaluator validatingTae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((ScenarioOptions)options.scenarioConfig, (AlgorithmExecutionConfig)execConfig, (boolean)false);
                String outputDir = System.getProperty("user.dir") + File.separator + "ValidationRun-" + new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss-SSS").format(new Date()) + File.separator;
                if (options.useScenarioOutDir) {
                    outputDir = options.scenarioConfig.outputDirectory + File.separator;
                }
                if (!((f = new File(outputDir)).mkdirs() || f.exists() && f.isDirectory() && f.canWrite())) {
                    throw new ParameterException("Couldn't make output Directory:" + outputDir);
                }
                log.info("Beginning Validation on {} entries", (Object)tfes.size());
                new Validator().validate(testInstances, options.validationOptions, options.scenarioConfig.cutoffTime, testInstanceSeedGen, validatingTae, outputDir, options.scenarioConfig.runObj, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, tfes, options.numRun);
                log.info("Validation Completed Successfully");
                validatingTae.notifyShutdown();
                System.exit(0);
            }
            catch (ParameterException e) {
                ConfigToLaTeX.usage((List)ConfigToLaTeX.getParameters((Object)options));
                throw e;
            }
        }
        catch (Throwable t) {
            int returnValue = 255;
            if (log != null) {
                log.error(exception, "Message: {}", (Object)t.getMessage());
                if (t instanceof NullPointerException) {
                    log.error("This error is most likely caused by an improper input file format, make sure the files are non empty / in the right format");
                }
                if (!(t instanceof ParameterException)) {
                    log.error(exception, "Exception:{}", (Object)t.getClass().getCanonicalName());
                    StringWriter sWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(sWriter);
                    t.printStackTrace(writer);
                    log.error(stackTrace, "StackTrace:{}", (Object)sWriter.toString());
                    returnValue = 1;
                }
                log.info("Exiting Application with failure");
                t = t.getCause();
            } else if (t instanceof ParameterException) {
                returnValue = 1;
                System.err.println(t.getMessage());
            } else {
                returnValue = 255;
                t.printStackTrace();
            }
            System.exit(returnValue);
        }
    }
}

