/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.matlab.helper;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.ParamFileHelper;
import ca.ubc.cs.beta.aclib.expectedimprovement.ExpectedExponentialImprovement;
import ca.ubc.cs.beta.aclib.misc.math.ArrayMathOps;
import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceHelper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import ec.util.MersenneTwister;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;

public class StaticMethodWrapper
implements Serializable {
    private static final long serialVersionUID = 6816563647209289030L;
    private static InstanceSeedGenerator instanceSeedGenerator;
    private static int instanceCount;
    private static ExpectedExponentialImprovement eei;

    public ParamConfiguration getRandomConfiguration(ParamConfigurationSpace p) {
        return p.getRandomConfiguration();
    }

    public ParamConfigurationSpace getParamFileParser(String s, long seedForRandomSampling) {
        return ParamFileHelper.getParamFileParser((String)s, (long)seedForRandomSampling);
    }

    public ParamConfigurationSpace getParamFileParser(File f, long seedForRandomSampling) {
        return ParamFileHelper.getParamFileParser((File)f, (long)seedForRandomSampling);
    }

    public ParamConfiguration fromString(ParamConfigurationSpace configSpace, String paramString) {
        return configSpace.getConfigurationFromString(paramString, ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
    }

    public void reinitSeed() {
        ParamFileHelper.clear();
        SeedableRandomSingleton.reinit();
    }

    public void setSeedOrInit(long seed) {
        ParamFileHelper.clear();
        SeedableRandomSingleton.setSeed((long)seed);
        SeedableRandomSingleton.reinit();
        if (seed != SeedableRandomSingleton.getSeed()) {
            throw new IllegalStateException("Seed could not be changed, perhaps you need to run clear java");
        }
        instanceSeedGenerator = new RandomInstanceSeedGenerator(instanceCount, seed);
    }

    public Random getTreeRandom() {
        return new MersenneTwister(24L);
    }

    public Random getRandomSingleton() {
        return SeedableRandomSingleton.getRandom();
    }

    public int[] getPermutation(int n) {
        return SeedableRandomSingleton.getPermutation((int)n, (int)1);
    }

    public int getNextSeed(int instanceID) {
        return instanceSeedGenerator.getNextSeed(Integer.valueOf(instanceID));
    }

    public void setInstanceCount(int instanceCount) {
        StaticMethodWrapper.instanceCount = instanceCount;
    }

    public RandomForest getRandomForest(int numTrees, double[][] allTheta, double[][] allX, int[][] theta_inst_idxs, double[] y, RegtreeBuildParams params) {
        return RandomForest.learnModel((int)numTrees, (double[][])allTheta, (double[][])allX, (int[][])theta_inst_idxs, (double[])y, (RegtreeBuildParams)params);
    }

    public int matlabHashCode(double[][] matrix) {
        return ArrayMathOps.matlabHashCode((double[][])matrix);
    }

    public int matlabHashSingular(double[] matrix) {
        double[][] obj = new double[][]{matrix};
        return this.matlabHashCode(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Method m : StaticMethodWrapper.class.getMethods()) {
            sb.append(m.getName()).append("=>(");
            for (Class<?> classes : m.getParameterTypes()) {
                sb.append(classes.getName());
                sb.append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public double expImp(double f_min, double mean, double var) {
        double[] predmean = new double[]{mean};
        double[] predvar = new double[]{var};
        double value = eei.computeNegativeExpectedImprovement(f_min, predmean, predvar)[0];
        return value;
    }

    public double[] expImp(double f_min, double[] mean, double[] var) {
        return eei.computeNegativeExpectedImprovement(f_min, mean, var);
    }

    public double[][] getNeighbours(ParamConfigurationSpace configSpace, double[] x) {
        ParamConfiguration config = configSpace.getConfigurationFromValueArray(x);
        List neighbours = config.getNeighbourhood();
        double[][] results = new double[neighbours.size()][];
        for (int i = 0; i < results.length; ++i) {
            results[i] = ((ParamConfiguration)neighbours.get(i)).toValueArray();
        }
        return results;
    }

    public double[][] getFeatures(String instanceFile, String experimentDir, String featureFileName) {
        try {
            InstanceListWithSeeds ilws = ProblemInstanceHelper.getInstances((String)instanceFile, (String)experimentDir, (String)featureFileName, (boolean)false);
            double[][] features = new double[ilws.getInstances().size()][];
            for (int i = 0; i < ilws.getInstances().size(); ++i) {
                features[i] = ((ProblemInstance)ilws.getInstances().get(i)).getFeaturesDouble();
            }
            return features;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        instanceCount = 0;
        eei = new ExpectedExponentialImprovement();
    }
}

