/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.lmt;

import java.util.Collections;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.lmt.CompareNode;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.classifiers.trees.lmt.ResidualModelSelection;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;

public class LMTNode
extends LogisticBase {
    static final long serialVersionUID = 1862737145870398755L;
    protected double m_totalInstanceWeight;
    protected int m_id;
    protected int m_leafModelNum;
    public double m_alpha;
    public double m_numIncorrectModel;
    public double m_numIncorrectTree;
    protected int m_minNumInstances;
    protected ModelSelection m_modelSelection;
    protected NominalToBinary m_nominalToBinary;
    protected SimpleLinearRegression[][] m_higherRegressions;
    protected int m_numHigherRegressions = 0;
    protected static int m_numFoldsPruning = 5;
    protected boolean m_fastRegression;
    protected int m_numInstances;
    protected ClassifierSplitModel m_localModel;
    protected LMTNode[] m_sons;
    protected boolean m_isLeaf;

    public LMTNode(ModelSelection modelSelection, int numBoostingIterations, boolean fastRegression, boolean errorOnProbabilities, int minNumInstances, double weightTrimBeta, boolean useAIC) {
        this.m_modelSelection = modelSelection;
        this.m_fixedNumIterations = numBoostingIterations;
        this.m_fastRegression = fastRegression;
        this.m_errorOnProbabilities = errorOnProbabilities;
        this.m_minNumInstances = minNumInstances;
        this.m_maxIterations = 200;
        this.setWeightTrimBeta(weightTrimBeta);
        this.setUseAIC(useAIC);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_fastRegression && this.m_fixedNumIterations < 0) {
            this.m_fixedNumIterations = this.tryLogistic(data);
        }
        Instances cvData = new Instances(data);
        cvData.stratify(m_numFoldsPruning);
        double[][] alphas = new double[m_numFoldsPruning][];
        double[][] errors = new double[m_numFoldsPruning][];
        for (int i = 0; i < m_numFoldsPruning; ++i) {
            Instances train = cvData.trainCV(m_numFoldsPruning, i);
            Instances test = cvData.testCV(m_numFoldsPruning, i);
            this.buildTree(train, null, train.numInstances(), 0.0);
            int numNodes = this.getNumInnerNodes();
            alphas[i] = new double[numNodes + 2];
            errors[i] = new double[numNodes + 2];
            this.prune(alphas[i], errors[i], test);
        }
        this.buildTree(data, null, data.numInstances(), 0.0);
        int numNodes = this.getNumInnerNodes();
        double[] treeAlphas = new double[numNodes + 2];
        int iterations = this.prune(treeAlphas, null, null);
        double[] treeErrors = new double[numNodes + 2];
        for (int i = 0; i <= iterations; ++i) {
            double alpha = Math.sqrt(treeAlphas[i] * treeAlphas[i + 1]);
            double error = 0.0;
            for (int k = 0; k < m_numFoldsPruning; ++k) {
                int l = 0;
                while (alphas[k][l] <= alpha) {
                    ++l;
                }
                error += errors[k][l - 1];
            }
            treeErrors[i] = error;
        }
        int best = -1;
        double bestError = Double.MAX_VALUE;
        for (int i = iterations; i >= 0; --i) {
            if (!(treeErrors[i] < bestError)) continue;
            bestError = treeErrors[i];
            best = i;
        }
        double bestAlpha = Math.sqrt(treeAlphas[best] * treeAlphas[best + 1]);
        this.unprune();
        this.prune(bestAlpha);
        this.cleanup();
    }

    public void buildTree(Instances data, SimpleLinearRegression[][] higherRegressions, double totalInstanceWeight, double higherNumParameters) throws Exception {
        boolean grow;
        this.m_totalInstanceWeight = totalInstanceWeight;
        this.m_train = new Instances(data);
        this.m_isLeaf = true;
        this.m_sons = null;
        this.m_numInstances = this.m_train.numInstances();
        this.m_numClasses = this.m_train.numClasses();
        this.m_numericData = this.getNumericData(this.m_train);
        this.m_numericDataHeader = new Instances(this.m_numericData, 0);
        this.m_regressions = this.initRegressions();
        this.m_numRegressions = 0;
        this.m_higherRegressions = higherRegressions != null ? higherRegressions : new SimpleLinearRegression[this.m_numClasses][0];
        this.m_numHigherRegressions = this.m_higherRegressions[0].length;
        this.m_numParameters = higherNumParameters;
        if (this.m_numInstances >= m_numFoldsBoosting) {
            if (this.m_fixedNumIterations > 0) {
                this.performBoosting(this.m_fixedNumIterations);
            } else if (this.getUseAIC()) {
                this.performBoostingInfCriterion();
            } else {
                this.performBoostingCV();
            }
        }
        this.m_numParameters += (double)this.m_numRegressions;
        this.m_regressions = this.selectRegressions(this.m_regressions);
        if (this.m_numInstances > this.m_minNumInstances) {
            if (this.m_modelSelection instanceof ResidualModelSelection) {
                double[][] probs = this.getProbs(this.getFs(this.m_numericData));
                double[][] trainYs = this.getYs(this.m_train);
                double[][] dataZs = this.getZs(probs, trainYs);
                double[][] dataWs = this.getWs(probs, trainYs);
                this.m_localModel = ((ResidualModelSelection)this.m_modelSelection).selectModel(this.m_train, dataZs, dataWs);
            } else {
                this.m_localModel = this.m_modelSelection.selectModel(this.m_train);
            }
            grow = this.m_localModel.numSubsets() > 1;
        } else {
            grow = false;
        }
        if (grow && !Thread.interrupted()) {
            this.m_isLeaf = false;
            Instances[] localInstances = this.m_localModel.split(this.m_train);
            this.m_sons = new LMTNode[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = new LMTNode(this.m_modelSelection, this.m_fixedNumIterations, this.m_fastRegression, this.m_errorOnProbabilities, this.m_minNumInstances, this.getWeightTrimBeta(), this.getUseAIC());
                this.m_sons[i].buildTree(localInstances[i], this.mergeArrays(this.m_regressions, this.m_higherRegressions), this.m_totalInstanceWeight, this.m_numParameters);
                localInstances[i] = null;
            }
        }
    }

    public void prune(double alpha) throws Exception {
        boolean prune;
        CompareNode comparator = new CompareNode();
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getNodes();
        boolean bl = prune = nodeList.size() > 0;
        while (prune) {
            LMTNode nodeToPrune = (LMTNode)Collections.min(nodeList, comparator);
            if (nodeToPrune.m_alpha > alpha) break;
            nodeToPrune.m_isLeaf = true;
            nodeToPrune.m_sons = null;
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getNodes();
            prune = nodeList.size() > 0;
        }
    }

    public int prune(double[] alphas, double[] errors, Instances test) throws Exception {
        Evaluation eval;
        CompareNode comparator = new CompareNode();
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getNodes();
        boolean prune = nodeList.size() > 0;
        alphas[0] = 0.0;
        if (errors != null) {
            eval = new Evaluation(test);
            eval.evaluateModel(this, test, new Object[0]);
            errors[0] = eval.errorRate();
        }
        int iteration = 0;
        while (prune) {
            LMTNode nodeToPrune = (LMTNode)Collections.min(nodeList, comparator);
            nodeToPrune.m_isLeaf = true;
            alphas[++iteration] = nodeToPrune.m_alpha;
            if (errors != null) {
                eval = new Evaluation(test);
                eval.evaluateModel(this, test, new Object[0]);
                errors[iteration] = eval.errorRate();
            }
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getNodes();
            prune = nodeList.size() > 0;
        }
        alphas[iteration + 1] = 1.0;
        return iteration;
    }

    protected void unprune() {
        if (this.m_sons != null) {
            this.m_isLeaf = false;
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].unprune();
            }
        }
    }

    protected int tryLogistic(Instances data) throws Exception {
        Instances filteredData = new Instances(data);
        NominalToBinary nominalToBinary = new NominalToBinary();
        nominalToBinary.setInputFormat(filteredData);
        filteredData = Filter.useFilter(filteredData, nominalToBinary);
        LogisticBase logistic = new LogisticBase(0, true, this.m_errorOnProbabilities);
        logistic.setMaxIterations(200);
        logistic.setWeightTrimBeta(this.getWeightTrimBeta());
        logistic.setUseAIC(this.getUseAIC());
        logistic.buildClassifier(filteredData);
        return logistic.getNumRegressions();
    }

    public int getNumInnerNodes() {
        if (this.m_isLeaf) {
            return 0;
        }
        int numNodes = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numNodes += this.m_sons[i].getNumInnerNodes();
        }
        return numNodes;
    }

    public int getNumLeaves() {
        int numLeaves;
        if (!this.m_isLeaf) {
            numLeaves = 0;
            int numEmptyLeaves = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                numLeaves += this.m_sons[i].getNumLeaves();
                if (!this.m_sons[i].m_isLeaf || this.m_sons[i].hasModels()) continue;
                ++numEmptyLeaves;
            }
            if (numEmptyLeaves > 1) {
                numLeaves -= numEmptyLeaves - 1;
            }
        } else {
            numLeaves = 1;
        }
        return numLeaves;
    }

    public void modelErrors() throws Exception {
        Evaluation eval = new Evaluation(this.m_train);
        if (!this.m_isLeaf) {
            this.m_isLeaf = true;
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_isLeaf = false;
            this.m_numIncorrectModel = eval.incorrect();
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].modelErrors();
            }
        } else {
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_numIncorrectModel = eval.incorrect();
        }
    }

    public void treeErrors() {
        if (this.m_isLeaf) {
            this.m_numIncorrectTree = this.m_numIncorrectModel;
        } else {
            this.m_numIncorrectTree = 0.0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].treeErrors();
                this.m_numIncorrectTree += this.m_sons[i].m_numIncorrectTree;
            }
        }
    }

    public void calculateAlphas() throws Exception {
        if (!this.m_isLeaf) {
            double errorDiff = this.m_numIncorrectModel - this.m_numIncorrectTree;
            if (errorDiff <= 0.0) {
                this.m_isLeaf = true;
                this.m_sons = null;
                this.m_alpha = Double.MAX_VALUE;
            } else {
                this.m_alpha = (errorDiff /= this.m_totalInstanceWeight) / (double)(this.getNumLeaves() - 1);
                for (int i = 0; i < this.m_sons.length; ++i) {
                    this.m_sons[i].calculateAlphas();
                }
            }
        } else {
            this.m_alpha = Double.MAX_VALUE;
        }
    }

    protected SimpleLinearRegression[][] mergeArrays(SimpleLinearRegression[][] a1, SimpleLinearRegression[][] a2) {
        int j;
        int i;
        int numModels1 = a1[0].length;
        int numModels2 = a2[0].length;
        SimpleLinearRegression[][] result = new SimpleLinearRegression[this.m_numClasses][numModels1 + numModels2];
        for (i = 0; i < this.m_numClasses; ++i) {
            for (j = 0; j < numModels1; ++j) {
                result[i][j] = a1[i][j];
            }
        }
        for (i = 0; i < this.m_numClasses; ++i) {
            for (j = 0; j < numModels2; ++j) {
                result[i][j + numModels1] = a2[i][j];
            }
        }
        return result;
    }

    public Vector getNodes() {
        Vector nodeList = new Vector();
        this.getNodes(nodeList);
        return nodeList;
    }

    public void getNodes(Vector nodeList) {
        if (!this.m_isLeaf) {
            nodeList.add(this);
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].getNodes(nodeList);
            }
        }
    }

    @Override
    protected Instances getNumericData(Instances train) throws Exception {
        Instances filteredData = new Instances(train);
        this.m_nominalToBinary = new NominalToBinary();
        this.m_nominalToBinary.setInputFormat(filteredData);
        filteredData = Filter.useFilter(filteredData, this.m_nominalToBinary);
        return super.getNumericData(filteredData);
    }

    @Override
    protected double[] getFs(Instance instance) throws Exception {
        double[] pred = new double[this.m_numClasses];
        double[] instanceFs = super.getFs(instance);
        for (int i = 0; i < this.m_numHigherRegressions; ++i) {
            int j;
            double predSum = 0.0;
            for (j = 0; j < this.m_numClasses; ++j) {
                pred[j] = this.m_higherRegressions[j][i].classifyInstance(instance);
                predSum += pred[j];
            }
            predSum /= (double)this.m_numClasses;
            for (j = 0; j < this.m_numClasses; ++j) {
                int n = j;
                instanceFs[n] = instanceFs[n] + (pred[j] - predSum) * (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
            }
        }
        return instanceFs;
    }

    public boolean hasModels() {
        return this.m_numRegressions > 0;
    }

    public double[] modelDistributionForInstance(Instance instance) throws Exception {
        instance = (Instance)instance.copy();
        this.m_nominalToBinary.input(instance);
        instance = this.m_nominalToBinary.output();
        instance.setDataset(this.m_numericDataHeader);
        return this.probs(this.getFs(instance));
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] probs;
        if (this.m_isLeaf) {
            probs = this.modelDistributionForInstance(instance);
        } else {
            int branch = this.m_localModel.whichSubset(instance);
            probs = this.m_sons[branch].distributionForInstance(instance);
        }
        return probs;
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numLeaves = 0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numLeaves += this.m_sons[i].numLeaves();
        }
        return numLeaves;
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int numNodes = 1;
        for (int i = 0; i < this.m_sons.length; ++i) {
            numNodes += this.m_sons[i].numNodes();
        }
        return numNodes;
    }

    @Override
    public String toString() {
        this.assignLeafModelNumbers(0);
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf) {
                text.append(": ");
                text.append("LM_" + this.m_leafModelNum + ":" + this.getModelParameters());
            } else {
                this.dumpTree(0, text);
            }
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the Tree : \t" + this.numNodes() + "\n");
            text.append(this.modelsToString());
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print logistic model tree";
        }
    }

    public String getModelParameters() {
        StringBuffer text = new StringBuffer();
        int numModels = this.m_numRegressions + this.m_numHigherRegressions;
        text.append(this.m_numRegressions + "/" + numModels + " (" + this.m_numInstances + ")");
        return text.toString();
    }

    protected void dumpTree(int depth, StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("\n");
            for (int j = 0; j < depth; ++j) {
                text.append("|   ");
            }
            text.append(this.m_localModel.leftSide(this.m_train));
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                text.append(": ");
                text.append("LM_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters());
                continue;
            }
            this.m_sons[i].dumpTree(depth + 1, text);
        }
    }

    public int assignIDs(int lastID) {
        int currLastID;
        this.m_id = currLastID = lastID + 1;
        if (this.m_sons != null) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                currLastID = this.m_sons[i].assignIDs(currLastID);
            }
        }
        return currLastID;
    }

    public int assignLeafModelNumbers(int leafCounter) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            for (int i = 0; i < this.m_sons.length; ++i) {
                leafCounter = this.m_sons[i].assignLeafModelNumbers(leafCounter);
            }
        } else {
            this.m_leafModelNum = ++leafCounter;
        }
        return leafCounter;
    }

    @Override
    protected double[][] getCoefficients() {
        double[][] coefficients = super.getCoefficients();
        double constFactor = (double)(this.m_numClasses - 1) / (double)this.m_numClasses;
        for (int j = 0; j < this.m_numClasses; ++j) {
            for (int i = 0; i < this.m_numHigherRegressions; ++i) {
                double slope = this.m_higherRegressions[j][i].getSlope();
                double intercept = this.m_higherRegressions[j][i].getIntercept();
                int attribute = this.m_higherRegressions[j][i].getAttributeIndex();
                double[] dArray = coefficients[j];
                dArray[0] = dArray[0] + constFactor * intercept;
                double[] dArray2 = coefficients[j];
                int n = attribute + 1;
                dArray2[n] = dArray2[n] + constFactor * slope;
            }
        }
        return coefficients;
    }

    public String modelsToString() {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf) {
            text.append("LM_" + this.m_leafModelNum + ":" + super.toString());
        } else {
            for (int i = 0; i < this.m_sons.length; ++i) {
                text.append("\n" + this.m_sons[i].modelsToString());
            }
        }
        return text.toString();
    }

    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        this.assignIDs(-1);
        this.assignLeafModelNumbers(0);
        text.append("digraph LMTree {\n");
        if (this.m_isLeaf) {
            text.append("N" + this.m_id + " [label=\"LM_" + this.m_leafModelNum + ":" + this.getModelParameters() + "\" " + "shape=box style=filled");
            text.append("]\n");
        } else {
            text.append("N" + this.m_id + " [label=\"" + this.m_localModel.leftSide(this.m_train) + "\" ");
            text.append("]\n");
            this.graphTree(text);
        }
        return text.toString() + "}\n";
    }

    private void graphTree(StringBuffer text) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            text.append("N" + this.m_id + "->" + "N" + this.m_sons[i].m_id + " [label=\"" + this.m_localModel.rightSide(i, this.m_train).trim() + "\"]\n");
            if (this.m_sons[i].m_isLeaf) {
                text.append("N" + this.m_sons[i].m_id + " [label=\"LM_" + this.m_sons[i].m_leafModelNum + ":" + this.m_sons[i].getModelParameters() + "\" " + "shape=box style=filled");
                text.append("]\n");
                continue;
            }
            text.append("N" + this.m_sons[i].m_id + " [label=\"" + this.m_sons[i].m_localModel.leftSide(this.m_train) + "\" ");
            text.append("]\n");
            this.m_sons[i].graphTree(text);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i].cleanup();
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

