/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class Utils {
    public static final double l10e = Math.log10(Math.E);

    public static int sum(int[] arr) {
        if (arr == null || arr.length == 0) {
            return 0;
        }
        int l = arr.length;
        int res = 0;
        for (int i = 0; i < l; ++i) {
            res += arr[i];
        }
        return res;
    }

    public static double sum(double[] arr) {
        if (arr == null || arr.length == 0) {
            return 0.0;
        }
        int l = arr.length;
        double res = 0.0;
        for (int i = 0; i < l; ++i) {
            res += arr[i];
        }
        return res;
    }

    public static double mean(double[] arr) {
        if (arr == null || arr.length == 0) {
            return 0.0;
        }
        return Utils.sum(arr) / (double)arr.length;
    }

    public static double var(double[] arr) {
        if (arr == null || arr.length == 0) {
            return 0.0;
        }
        int l = arr.length;
        double sum = 0.0;
        double sumSq = 0.0;
        for (int i = 0; i < l; ++i) {
            sum += arr[i];
            sumSq += arr[i] * arr[i];
        }
        return (sumSq - sum * sum / (double)l) / (double)Math.max(l - 1, 1);
    }

    public static double median(double[] arr) {
        if (arr == null || arr.length == 0) {
            return Double.NaN;
        }
        int l = arr.length;
        Arrays.sort(arr);
        return arr[(int)Math.floor((double)l / 2.0)] / 2.0 + arr[(int)Math.ceil((double)l / 2.0)] / 2.0;
    }

    public static double prod(double[] arr, int start, int end) {
        double result = 1.0;
        for (int i = start; i < end; ++i) {
            result *= arr[i];
        }
        return result;
    }

    public static double[] mode(double[] arr) {
        HashMap<Double, Integer> freq = new HashMap<Double, Integer>();
        int highestFreq = 0;
        Vector<Double> best = new Vector<Double>();
        for (int i = 0; i < arr.length; ++i) {
            Integer cur = (Integer)freq.get(arr[i]);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            if (cur > highestFreq) {
                highestFreq = cur;
                best.clear();
            }
            if (cur == highestFreq) {
                best.add(arr[i]);
            }
            freq.put(arr[i], cur);
        }
        double[] retn = new double[best.size()];
        for (int i = 0; i < best.size(); ++i) {
            retn[i] = (Double)best.elementAt(i);
        }
        return retn;
    }

    public static double[][] transform(double[][] X, int[] keptColumns, double[] scale, double[] bias) {
        if (X == null) {
            throw new RuntimeException("X is null in transform.");
        }
        if (X.length == 0 || keptColumns == null) {
            return X;
        }
        if (scale == null || bias == null || keptColumns.length != scale.length || keptColumns.length != bias.length) {
            throw new RuntimeException("Badly formatted inputs to transform.");
        }
        double[][] ret = new double[X.length][keptColumns.length];
        for (int i = 0; i < X.length; ++i) {
            int k = 0;
            for (int j = 0; j < X[i].length && k < keptColumns.length; ++j) {
                if (j != keptColumns[k]) continue;
                ret[i][k] = (X[i][j] - bias[k]) / scale[k];
                ++k;
            }
        }
        return ret;
    }
}

