/*
 * Decompiled with CFR 0.152.
 */
package org.StructureGraphic.v1;

import java.awt.Color;
import java.awt.Graphics2D;
import org.StructureGraphic.v1.DSGraphicalTreeNode;
import org.StructureGraphic.v1.DSTreeNode;
import org.StructureGraphic.v1.DSTreeParser;
import org.StructureGraphic.v1.TextUtils;

public class DSTreeCopy {
    public static final Color DEFAULT_COLOR = Color.BLACK;

    public static DSVTreeNode createVertical(DSTreeNode r) {
        if (r == null) {
            r = new DSTreeParser.DSSimpleNode("null");
        }
        int width = -DSVTreeNode.HSPACE;
        int height = 0;
        DSTreeNode[] children = r.DSgetChildren();
        DSVTreeNode[] rootChildren = new DSVTreeNode[children.length];
        int[] centerXOffsets = new int[children.length];
        for (int i = 0; i < rootChildren.length; ++i) {
            rootChildren[i] = DSTreeCopy.createVertical(children[i]);
            centerXOffsets[i] = (width += rootChildren[i].DSgetWidth() + DSVTreeNode.HSPACE) - rootChildren[i].DSgetWidth() / 2;
            height = Math.max(height, rootChildren[i].DSgetHeight());
        }
        height += DSVTreeNode.HEIGHT;
        if (children.length != 0) {
            height += DSVTreeNode.VSPACE;
        }
        width = Math.max(width, DSVTreeNode.WIDTH);
        DSVTreeNode root = new DSVTreeNode(r, width, height);
        root.children = rootChildren;
        root.centerXOffsets = centerXOffsets;
        return root;
    }

    public static class DSVTreeNode
    extends DSSimpleGraphicalNode {
        public static int HSPACE = 4;
        public static int VSPACE = 15;
        public static int WIDTH = 60;
        public static int HEIGHT = 25;
        public int[] centerXOffsets;

        public DSVTreeNode(DSTreeNode n, int width, int height) {
            super(n, width, height);
        }

        public void DSpaint(Graphics2D g) {
            int xOff = (this.width - WIDTH) / 2;
            Color originalColor = g.getColor();
            g.setColor(this.color != null ? this.color : Color.BLACK);
            g.translate(xOff, 0);
            g.drawRect(0, 0, WIDTH, HEIGHT);
            if (this.value.length() > 0) {
                TextUtils.drawCenteredText(g, this.value, WIDTH / 2, HEIGHT / 2);
            }
            g.translate(-xOff, 0);
            g.setColor(originalColor);
            if (this.children.length != 0) {
                g.translate(0, HEIGHT + VSPACE);
                xOff = 0;
                for (DSVTreeNode child : this.children) {
                    child.DSpaint(g);
                    int temp = child.width + HSPACE;
                    g.translate(temp, 0);
                    xOff += temp;
                }
                g.translate(-xOff, 0);
                for (int i = 0; i < this.children.length; ++i) {
                    g.drawLine(this.width / 2, -VSPACE, this.centerXOffsets[i], 0);
                }
                g.translate(0, -(HEIGHT + VSPACE));
            }
        }
    }

    public static abstract class DSSimpleGraphicalNode
    implements DSGraphicalTreeNode {
        public String value;
        public Color color;
        public DSVTreeNode[] children;
        public int width;
        public int height;

        public DSSimpleGraphicalNode(DSTreeNode n, int width, int height) {
            this.value = n.DSgetValue() == null ? "null" : n.DSgetValue().toString();
            this.color = n.DSgetColor() == null ? DEFAULT_COLOR : n.DSgetColor();
            this.width = width;
            this.height = height;
        }

        public DSTreeNode[] DSgetChildren() {
            return this.children;
        }

        public Color DSgetColor() {
            return this.color;
        }

        public String DSgetValue() {
            return this.value;
        }

        public int DSgetWidth() {
            return this.width;
        }

        public int DSgetHeight() {
            return this.height;
        }
    }
}

