/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import ca.ubc.cs.beta.aclib.algorithmrun.AbstractAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.logback.MarkerFilter;
import ca.ubc.cs.beta.aclib.misc.logging.LoggingMarker;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandLineAlgorithmRun
extends AbstractAlgorithmRun {
    private static final long serialVersionUID = -70897405824987641L;
    public static final String AUTOMATIC_CONFIGURATOR_RESULT_REGEX = "^\\s*(Final)?\\s*[Rr]esult\\s+(?:(for)|(of))\\s+(?:(HAL)|(ParamILS)|(SMAC)|(this wrapper)):";
    private static final Pattern pattern = Pattern.compile("^\\s*(Final)?\\s*[Rr]esult\\s+(?:(for)|(of))\\s+(?:(HAL)|(ParamILS)|(SMAC)|(this wrapper)):");
    private static transient Logger log = LoggerFactory.getLogger(CommandLineAlgorithmRun.class);
    private Queue<String> outputQueue = new ArrayDeque<String>(2000);
    private static transient Marker execCommandMarker = MarkerFactory.getMarker((String)LoggingMarker.COMMAND_LINE_CALL.name());
    private static transient Marker fullProcessOutputMarker = MarkerFactory.getMarker((String)LoggingMarker.FULL_PROCESS_OUTPUT.name());
    public static ExecutorService threadPoolExecutor;
    private static final int MAX_LINES_TO_SAVE = 1000;

    public CommandLineAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        super(execConfig, runConfig);
        if (runConfig.getCutoffTime() <= 0.0) {
            log.info("Cap time is negative for {} setting run as timedout", (Object)runConfig);
            String rawResultLine = "[DIDN'T BOTHER TO RUN ALGORITHM AS THE CAPTIME IS NOT POSITIVE]";
            this.setResult(RunResult.TIMEOUT, 0.0, 0.0, 0.0, runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
        }
    }

    @Override
    public synchronized void run() {
        if (this.isRunCompleted()) {
            return;
        }
        try {
            Process proc;
            this.startWallclockTimer();
            final Process innerProcess = proc = this.runProcess();
            final Semaphore stdErrorDone = new Semaphore(0);
            Runnable standardErrorReader = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Scanner procIn = new Scanner(innerProcess.getErrorStream());
                        while (procIn.hasNext()) {
                            log.warn(procIn.nextLine());
                        }
                        procIn.close();
                    }
                    finally {
                        stdErrorDone.release();
                    }
                }
            };
            threadPoolExecutor.execute(standardErrorReader);
            Scanner procIn = new Scanner(proc.getInputStream());
            this.processRunLoop(procIn);
            if (!this.isRunCompleted()) {
                this.setCrashResult("We did not successfully read anything from the wrapper");
                log.error("We did not find anything in our target algorithm run output that matched our regex (i.e. We found nothing that looked like \"Result For ParamILS: x,x,x,x,x\", specifically the regex we were matching is: {} ", (Object)AUTOMATIC_CONFIGURATOR_RESULT_REGEX);
            }
            switch (this.getRunResult()) {
                case ABORT: 
                case CRASHED: {
                    log.info("Failed Run Detected Call: cd {} ;  {} ", (Object)this.execConfig.getAlgorithmExecutionDirectory(), (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig));
                    log.info("Failed Run Detected output last {} lines", (Object)this.outputQueue.size());
                    for (String s : this.outputQueue) {
                        log.info(s);
                    }
                    log.info("Output complete");
                }
            }
            this.outputQueue.clear();
            procIn.close();
            stdErrorDone.acquireUninterruptibly();
            proc.destroy();
            this.stopWallclockTimer();
        }
        catch (IOException e1) {
            String execCmd = CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig);
            log.error("Failed to execute command: {}", (Object)execCmd);
            throw new IllegalStateException(e1);
        }
    }

    public void processRunLoop(Scanner procIn) {
        while (procIn.hasNext()) {
            String line = procIn.nextLine();
            this.outputQueue.add(line);
            if (this.outputQueue.size() > 1000) {
                this.outputQueue.poll();
            }
            this.processLine(line);
        }
        procIn.close();
    }

    private Process runProcess() throws IOException {
        String execCmd = CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig);
        if (MarkerFilter.log(execCommandMarker.getName())) {
            log.info("Call: cd {} ;  {} ", (Object)this.execConfig.getAlgorithmExecutionDirectory(), (Object)execCmd);
        }
        Process proc = Runtime.getRuntime().exec(execCmd, null, new File(this.execConfig.getAlgorithmExecutionDirectory()));
        return proc;
    }

    public static String getTargetAlgorithmExecutionCommand(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        StringBuilder execString = new StringBuilder();
        execString.append(execConfig.getAlgorithmExecutable()).append(" ").append(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceName()).append(" ").append(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation()).append(" ").append(runConfig.getCutoffTime()).append(" ").append(Integer.MAX_VALUE).append(" ").append(runConfig.getProblemInstanceSeedPair().getSeed()).append(" ").append(runConfig.getParamConfiguration().getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
        return execString.toString();
    }

    public void processLine(String line) {
        Matcher matcher = pattern.matcher(line);
        String rawResultLine = "[No Matching Output Found]";
        if (MarkerFilter.log(fullProcessOutputMarker.getName())) {
            log.debug(line);
        }
        if (matcher.find()) {
            String fullLine = line.trim();
            String additionalRunData = "";
            try {
                String acExecResultString = line.substring(matcher.end()).trim();
                String[] results = acExecResultString.split(",");
                for (int i = 0; i < results.length; ++i) {
                    results[i] = results[i].trim();
                }
                rawResultLine = acExecResultString;
                RunResult acResult = RunResult.getAutomaticConfiguratorResultForKey(results[0]);
                int solved = acResult.getResultCode();
                String runtime = results[1].trim();
                String runLength = results[2].trim();
                String bestSolution = results[3].trim();
                String seed = results[4].trim();
                if (results.length > 5) {
                    if (results.length == 6) {
                        additionalRunData = results[5].trim();
                    } else {
                        log.warn("Too many fields were encounted (expected 5 or 6) when parsing line (Additional Run Data cannot have commas): {}\n ", (Object)line);
                    }
                }
                double runLengthD = Double.valueOf(runLength);
                double runtimeD = Double.valueOf(runtime);
                double qualityD = Double.valueOf(bestSolution);
                long resultSeedD = Long.valueOf(seed);
                if (!MarkerFilter.log(fullProcessOutputMarker.getName())) {
                    log.info("Algorithm Reported: {}", (Object)line);
                }
                this.setResult(acResult, runtimeD, runLengthD, qualityD, resultSeedD, rawResultLine, additionalRunData);
            }
            catch (NumberFormatException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely one of the values of runLength, runtime, quality could not be parsed as a Double, or the seed could not be parsed as a valid long", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
            }
            catch (IllegalArgumentException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                ArrayList<String> validValues = new ArrayList<String>();
                for (RunResult r : RunResult.values()) {
                    validValues.addAll(r.getAliases());
                }
                Collections.sort(validValues);
                Object[] validArgs = validValues.toArray(new String[0]);
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig), fullLine, Arrays.toString(validArgs)};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the Algorithm did not report a result string as one of: {}", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the algorithm did not specify all of the required outputs that is <solved>,<runtime>,<runlength>,<quality>,<seed>", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
            }
        }
    }

    static {
        log.warn("This version of SMAC hardcodes run length for calls to the target algorithm to {}.", (Object)Integer.MAX_VALUE);
        threadPoolExecutor = Executors.newCachedThreadPool();
    }
}

