/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum RunResult {
    TIMEOUT(0),
    SAT(1, "SAT", "SATISFIABLE"),
    UNSAT(2, "UNSAT", "UNSATISFIABLE"),
    CRASHED(-1),
    ABORT(-2);

    private final int resultCode;
    private final Set<String> resultKey = new HashSet<String>();

    private RunResult(int resultCode) {
        this.resultCode = resultCode;
        this.resultKey.add(this.toString());
    }

    private RunResult(int resultCode, String ... keys) {
        this.resultCode = resultCode;
        this.resultKey.addAll(Arrays.asList(keys));
    }

    public static RunResult getAutomaticConfiguratorResultForKey(String key) {
        key = key.toUpperCase();
        for (RunResult r : RunResult.values()) {
            if (!r.resultKey.contains(key)) continue;
            return r;
        }
        throw new IllegalArgumentException("No Match For Result from Automatic Configurator: " + key);
    }

    public static RunResult getAutomaticConfiguratorResultForCode(int resultCode) {
        for (RunResult r : RunResult.values()) {
            if (r.resultCode != resultCode) continue;
            return r;
        }
        throw new IllegalArgumentException("No Match For Result from Automatic Configurator");
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isSolved() {
        return this.resultCode == 1;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.resultKey);
    }
}

