/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.ConcurrentAlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.SingleThreadedAlgorithmRunner;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticConfiguratorFactory {
    private static int maxThreads = Runtime.getRuntime().availableProcessors();
    private static Logger log = LoggerFactory.getLogger(AutomaticConfiguratorFactory.class);

    public static void setMaximumNumberOfThreads(int threads) {
        maxThreads = threads;
    }

    public static AlgorithmRunner getSingleThreadedAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs) {
        return new SingleThreadedAlgorithmRunner(execConfig, runConfigs);
    }

    public static AlgorithmRunner getConcurrentAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs) {
        if (runConfigs.size() == 1) {
            return AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner(execConfig, runConfigs);
        }
        return AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner(execConfig, runConfigs, maxThreads);
    }

    public static AlgorithmRunner getConcurrentAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, int nThreads) {
        log.info("Concurrent Algorithm Runner created allowing {} threads");
        return new ConcurrentAlgorithmRunner(execConfig, runConfigs, nThreads);
    }
}

