/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.execconfig;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmExecutionConfig
implements Serializable {
    private static final long serialVersionUID = -1009816326679512474L;
    private final String algorithmExecutable;
    private final String algorithmExecutionDirectory;
    private final ParamConfigurationSpace paramFile;
    private final boolean executeOnCluster;
    private final boolean deterministicAlgorithm;
    private final double cutoffTime;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AlgorithmExecutionConfig(String algorithmExecutable, String algorithmExecutionDirectory, ParamConfigurationSpace paramFile, boolean executeOnCluster, boolean deterministicAlgorithm, double cutoffTime) {
        this.algorithmExecutable = algorithmExecutable;
        this.algorithmExecutionDirectory = algorithmExecutionDirectory;
        this.paramFile = paramFile;
        this.executeOnCluster = executeOnCluster;
        this.deterministicAlgorithm = deterministicAlgorithm;
        if (cutoffTime < 0.0) {
            throw new IllegalArgumentException("Cutoff time must be greater than zero");
        }
        if (cutoffTime == 0.0) {
            this.log.warn("Cutoff time is greater than zero");
        }
        this.cutoffTime = cutoffTime;
    }

    public String getAlgorithmExecutable() {
        return this.algorithmExecutable;
    }

    public String getAlgorithmExecutionDirectory() {
        return this.algorithmExecutionDirectory;
    }

    public ParamConfigurationSpace getParamFile() {
        return this.paramFile;
    }

    public boolean isExecuteOnCluster() {
        return this.executeOnCluster;
    }

    public boolean isDeterministicAlgorithm() {
        return this.deterministicAlgorithm;
    }

    public int hashCode() {
        return this.algorithmExecutable.hashCode() ^ this.algorithmExecutionDirectory.hashCode() ^ this.paramFile.hashCode() ^ (this.executeOnCluster ? 0 : 1) ^ (this.deterministicAlgorithm ? 0 : 1);
    }

    public String toString() {
        return "algoExec:" + this.algorithmExecutable + "\nAlgorithmExecutionDirectory:" + this.algorithmExecutionDirectory + "\n" + this.paramFile + "\n Cluster:" + this.executeOnCluster + "\nDetermininstic:" + this.deterministicAlgorithm;
    }

    public boolean equals(Object o) {
        if (o instanceof AlgorithmExecutionConfig) {
            AlgorithmExecutionConfig co = (AlgorithmExecutionConfig)o;
            return co.algorithmExecutable.equals(this.algorithmExecutable) && co.algorithmExecutionDirectory.equals(this.algorithmExecutionDirectory) && co.executeOnCluster == this.executeOnCluster && co.paramFile.equals(this.paramFile) && co.deterministicAlgorithm == this.deterministicAlgorithm;
        }
        return false;
    }

    public double getAlgorithmCutoffTime() {
        return this.cutoffTime;
    }
}

