/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.math.distribution;

import ca.ubc.cs.beta.aclib.misc.random.SeedableRandomSingleton;
import java.util.Random;
import net.sf.doodleproject.numerics4j.special.Erf;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;

public class TruncatedNormalDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = -901332698348589236L;
    private final double mu;
    private final double variance;
    private final double sigma;
    private final double kappa;
    private final NormalDistribution norm;
    private final Random random;

    public TruncatedNormalDistribution(double mean, double variance, double kappa, Random rand) {
        this.mu = mean;
        this.variance = variance;
        this.kappa = kappa;
        this.sigma = Math.sqrt(variance);
        this.norm = new NormalDistribution();
        this.random = rand;
    }

    public double cumulativeProbability(double x) {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public double density(double x) {
        if (x < this.kappa) {
            return 0.0;
        }
        double numerator = 1.0 / this.sigma * this.norm.density((x - this.mu) / this.sigma);
        double denominator = 1.0 - this.norm.cumulativeProbability((this.mu - this.kappa) / this.sigma);
        return numerator / denominator;
    }

    public double getNumericalMean() {
        return this.mu;
    }

    public double getNumericalVariance() {
        return this.variance;
    }

    public double getSupportLowerBound() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public double getSupportUpperBound() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public boolean isSupportConnected() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public boolean isSupportLowerBoundInclusive() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public boolean isSupportUpperBoundInclusive() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public double erfinv(double x) {
        return Erf.inverseErf((double)x);
    }

    public double sample() {
        double u = this.random.nextDouble();
        return this.inverseCDF(u);
    }

    public double inverseCDF(double u) {
        double PHIl = this.norm.cumulativeProbability((this.kappa - this.mu) / this.sigma);
        double PHIr = this.norm.cumulativeProbability((Double.POSITIVE_INFINITY - this.mu) / this.sigma);
        double sample = this.mu + this.sigma * (Math.sqrt(2.0) * this.erfinv(2.0 * (PHIl + (PHIr - PHIl) * u) - 1.0));
        return sample;
    }

    public double[] getValuesAtStratifiedShuffledIntervals(int numSamples) {
        double increment = 1.0 / ((double)numSamples + 1.0);
        double[] result = new double[numSamples];
        double current = increment;
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.inverseCDF(current);
            current += increment;
        }
        result = SeedableRandomSingleton.getPermutationOfArray(result);
        return result;
    }

    public double[] getValuesAtStratifiedIntervals(int numSamples) {
        double increment = 1.0 / ((double)numSamples + 1.0);
        double[] result = new double[numSamples];
        double current = increment;
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.inverseCDF(current);
            current += increment;
        }
        return result;
    }

    public double probability(double arg0) {
        return 0.0;
    }
}

