/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.random;

import ec.util.MersenneTwister;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SeedableRandomSingleton {
    private static Long seed;
    private static boolean init;
    private static Random rand;
    private static final boolean log = false;
    private static final boolean mersenne = true;

    private SeedableRandomSingleton() {
        throw new IllegalStateException();
    }

    public static void setSeed(long seed) {
        if (!init) {
            SeedableRandomSingleton.seed = seed;
            SeedableRandomSingleton.init();
        }
    }

    public static void setRandom(Random r) {
        rand = r;
    }

    public static long getSeed() {
        return seed;
    }

    public static synchronized void reinit() {
        System.out.println("[INFO]: Reinitializing seed");
        if (!init) {
            SeedableRandomSingleton.init();
        }
        System.out.println("[INFO]: Mersenne Twister PRNG Enabled");
        rand = new MersenneTwister(seed);
        System.out.println("[INFO]: Random Logging Disabled");
    }

    private static synchronized void init() {
        if (init) {
            throw new IllegalStateException();
        }
        init = true;
        if (seed == null) {
            seed = System.currentTimeMillis();
            System.out.println("[INFO]: Seed chosen randomly to:" + seed);
        } else {
            System.out.println("[INFO]: Seed set via CLI to:" + seed);
        }
        System.out.println("[INFO]: Mersenne Twister PRNG Enabled");
        rand = new MersenneTwister(seed);
        System.out.println("[INFO]: Random Logging Disabled");
    }

    public static Random getRandom() {
        if (rand == null) {
            SeedableRandomSingleton.init();
        }
        return rand;
    }

    public static int[] getPermutation(int n, int offset, Random rand) {
        int i;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int[] perm = new int[n];
        for (i = 0; i < n; ++i) {
            perm[i] = i + offset;
        }
        for (i = n - 1; i > 0; --i) {
            int rndIdx = rand.nextInt(i + 1);
            int tmp = perm[i];
            perm[i] = perm[rndIdx];
            perm[rndIdx] = tmp;
        }
        return perm;
    }

    public static int[] getPermutation(int n, int offset) {
        return SeedableRandomSingleton.getPermutation(n, offset, rand);
    }

    public static void permuteList(List list, int[] permutations) {
        if (permutations.length != list.size()) {
            throw new IllegalArgumentException("List length and permutation length are not equal");
        }
        ArrayList tmpList = new ArrayList(permutations.length);
        for (int i = 0; i < permutations.length; ++i) {
            tmpList.add(list.get(permutations[i]));
        }
        list.clear();
        list.addAll(tmpList);
    }

    public static double[] getPermutationOfArray(double[] input) {
        int[] permutation = SeedableRandomSingleton.getPermutation(input.length, 0);
        double[] result = new double[input.length];
        for (int i = 0; i < permutation.length; ++i) {
            result[i] = input[permutation[i]];
        }
        return result;
    }

    static {
        init = false;
        rand = null;
    }
}

