/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.objectives;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;

public enum RunObjective {
    RUNTIME,
    QUALITY;


    public double getObjective(AlgorithmRun r) {
        switch (this) {
            case RUNTIME: {
                switch (r.getRunResult()) {
                    case CRASHED: 
                    case TIMEOUT: {
                        return r.getRunConfig().getCutoffTime();
                    }
                }
                return r.getRuntime();
            }
            case QUALITY: {
                return r.getQuality();
            }
        }
        throw new UnsupportedOperationException(this.toString() + " Run Objective Not Implemented");
    }

    public void validateInstanceSpecificInformation(ProblemInstance pi) {
        switch (this) {
            case RUNTIME: 
            case QUALITY: {
                return;
            }
        }
        throw new UnsupportedOperationException(this.toString() + " Run Objective Not Implemented");
    }
}

