/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTargetAlgorithmEvaluator
implements TargetAlgorithmEvaluator {
    protected final AlgorithmExecutionConfig execConfig;
    protected int runCount = 0;

    public AbstractTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig) {
        this.execConfig = execConfig;
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.evaluateRun(Collections.singletonList(run));
    }

    @Override
    public abstract List<AlgorithmRun> evaluateRun(List<RunConfig> var1);

    @Override
    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public int getRunHash() {
        return 0;
    }

    @Override
    public void seek(List<AlgorithmRun> runs) {
        this.runCount = runs.size();
    }

    protected void addRuns(List<AlgorithmRun> runs) {
        this.runCount += runs.size();
    }

    @Override
    public String getManualCallString(RunConfig runConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append("cd ").append(this.execConfig.getAlgorithmExecutionDirectory()).append("; ");
        sb.append(CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, runConfig));
        sb.append("");
        return sb.toString();
    }
}

