/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCrashedRunsTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private int runCount = 0;
    private final int retryCount;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public RetryCrashedRunsTargetAlgorithmEvaluator(int retryCount, TargetAlgorithmEvaluator tae) {
        super(tae);
        if (retryCount < 0) {
            throw new IllegalArgumentException("Retry Count should be atleast 0");
        }
        this.retryCount = retryCount;
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.evaluateRun(Collections.singletonList(run));
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs);
        runs = new ArrayList<AlgorithmRun>(runs);
        for (int i = 1; i <= this.retryCount; ++i) {
            HashMap<RunConfig, Integer> crashedRuns = new HashMap<RunConfig, Integer>();
            boolean crashedRunsExist = false;
            for (int j = 0; j < runs.size(); ++j) {
                AlgorithmRun run = runs.get(j);
                if (!run.getRunResult().equals((Object)RunResult.CRASHED)) continue;
                crashedRuns.put(run.getRunConfig(), j);
                crashedRunsExist = true;
            }
            if (!crashedRunsExist) {
                this.log.debug("No crashed runs to retry");
                break;
            }
            this.log.info("Retrying {} crashed runs (Attempt {})", (Object)crashedRuns.size(), (Object)i);
            ArrayList<RunConfig> crashRCs = new ArrayList<RunConfig>(crashedRuns.keySet().size());
            crashRCs.addAll(crashedRuns.keySet());
            List<AlgorithmRun> retriedRuns = this.tae.evaluateRun(crashRCs);
            for (AlgorithmRun run : retriedRuns) {
                runs.set((Integer)crashedRuns.get(run.getRunConfig()), run);
            }
        }
        this.runCount += runs.size();
        return runs;
    }

    @Override
    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public void seek(List<AlgorithmRun> runs) {
        this.tae.seek(runs);
        this.runCount = runs.size();
    }
}

