/*
 * Decompiled with CFR 0.152.
 */
package org.six11.util.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class PCA {
    Matrix covMatrix;
    EigenvalueDecomposition eigenstuff;
    double[] eigenvalues;
    Matrix eigenvectors;
    SortedSet<PrincipleComponent> principleComponents;
    double[] means;

    public static void main(String[] args) throws IOException {
        Object matrix;
        String source = null;
        if (args.length > 0) {
            List<Double> vec;
            source = "from disk";
            ArrayList data = new ArrayList();
            File inFile = new File(args[0]);
            BufferedReader br = new BufferedReader(new FileReader(inFile));
            int numElements = -1;
            while (br.ready()) {
                StringTokenizer line = new StringTokenizer(br.readLine());
                vec = new ArrayList();
                data.add(vec);
                while (line.hasMoreTokens()) {
                    vec.add(Double.parseDouble(line.nextToken()));
                }
                numElements = vec.size();
            }
            matrix = new double[data.size()][numElements];
            for (int i = 0; i < data.size(); ++i) {
                vec = (List)data.get(i);
                for (int j = 0; j < vec.size(); ++j) {
                    matrix[i][j] = (Double)vec.get(j);
                }
            }
        } else {
            source = "from the Smith MessyMathHelperClass tutorial";
            matrix = new double[][]{{2.5, 2.4}, {0.5, 0.7}, {2.2, 2.9}, {1.9, 2.2}, {3.1, 3.0}, {2.3, 2.7}, {2.0, 1.6}, {1.0, 1.1}, {1.5, 1.6}, {1.1, 0.9}};
            PCA.bug(" **");
            PCA.bug(" ** Note: You can put data in a plain text file and mention its ");
            PCA.bug(" ** name on the command line if you want to process different data.");
            PCA.bug(" ** Just put each sample vector on a row, with scalar values whitespace-separated.");
            PCA.bug(" ** Example of three samples with 2 dimensions:");
            PCA.bug(" **");
            PCA.bug(" ** 2.3 9.01");
            PCA.bug(" ** 2.5 8.604");
            PCA.bug(" ** 2.22 8.24");
            PCA.bug(" **");
            PCA.bug(" ** ALSO: note the eigenvalues in the Smith tutorial have different sign than the");
            PCA.bug(" ** eigenvalues calculated here. This is not a problem, because the orientation should");
            PCA.bug(" ** not matter as long as the orientations are used consistently.");
        }
        Matrix originalData = new Matrix(matrix);
        PCA.bug("Here is the original data from " + source + ", before adjusting by each dimension mean:");
        originalData.print(8, 4);
        PCA pca = new PCA((double[][])matrix);
        int numComponents = pca.getNumComponents();
        PCA.bug("There are " + numComponents + " components");
        int k = 2;
        List<PrincipleComponent> mainComponents = pca.getDominantComponents(k);
        int counter = 1;
        PCA.bug("Showing top " + k + " principle components.");
        for (PrincipleComponent pc : mainComponents) {
            PCA.bug("Component " + counter++ + ": " + pc);
        }
        Matrix features = PCA.getDominantComponentsMatrix(mainComponents);
        PCA.bug("Feature matrix (k=" + k + ") :");
        features.print(8, 4);
        Matrix featuresXpose = features.transpose();
        PCA.bug("Xposed feature matrix (k=" + k + ") :");
        featuresXpose.print(8, 4);
        double[][] matrixAdjusted = PCA.getMeanAdjusted(matrix, pca.getMeans());
        Matrix adjustedInput = new Matrix(matrixAdjusted);
        PCA.bug("Original input adjusted by dimension means (k=" + k + ") :");
        adjustedInput.print(8, 4);
        Matrix xformedData = featuresXpose.times(adjustedInput.transpose());
        PCA.bug("Transformed data into MessyMathHelperClass-space (k=" + k + ") :");
        xformedData.transpose().print(8, 4);
        k = 1;
        mainComponents = pca.getDominantComponents(k);
        counter = 1;
        PCA.bug("Showing top " + k + " principle components.");
        for (PrincipleComponent pc : mainComponents) {
            PCA.bug("Component " + counter++ + ": " + pc);
        }
        features = PCA.getDominantComponentsMatrix(mainComponents);
        PCA.bug("Feature matrix (k=" + k + ") :");
        features.print(8, 4);
        featuresXpose = features.transpose();
        PCA.bug("Xposed feature matrix (k=" + k + ") :");
        featuresXpose.print(8, 4);
        matrixAdjusted = PCA.getMeanAdjusted(matrix, pca.getMeans());
        adjustedInput = new Matrix(matrixAdjusted);
        PCA.bug("Original input adjusted by dimension means (k=" + k + ") :");
        adjustedInput.print(8, 4);
        xformedData = featuresXpose.times(adjustedInput.transpose());
        PCA.bug("Transformed data into MessyMathHelperClass-space (k=" + k + ") :");
        xformedData.transpose().print(8, 4);
    }

    public PCA(double[][] input) {
        this.means = new double[input[0].length];
        double[][] cov = PCA.getCovariance(input, this.means);
        this.covMatrix = new Matrix(cov);
        this.eigenstuff = this.covMatrix.eig();
        this.eigenvalues = this.eigenstuff.getRealEigenvalues();
        this.eigenvectors = this.eigenstuff.getV();
        double[][] vecs = this.eigenvectors.getArray();
        int numComponents = this.eigenvectors.getColumnDimension();
        this.principleComponents = new TreeSet<PrincipleComponent>();
        for (int i = 0; i < numComponents; ++i) {
            double[] eigenvector = new double[numComponents];
            for (int j = 0; j < numComponents; ++j) {
                eigenvector[j] = vecs[i][j];
            }
            this.principleComponents.add(new PrincipleComponent(this.eigenvalues[i], eigenvector));
        }
    }

    public double[] getMeans() {
        return this.means;
    }

    public static double[][] getMeanAdjusted(double[][] input, double[] mean) {
        int nRows = input.length;
        int nCols = input[0].length;
        double[][] ret = new double[nRows][nCols];
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                ret[row][col] = input[row][col] - mean[col];
            }
        }
        return ret;
    }

    public List<PrincipleComponent> getDominantComponents(int n) {
        ArrayList<PrincipleComponent> ret = new ArrayList<PrincipleComponent>();
        int count = 0;
        for (PrincipleComponent pc : this.principleComponents) {
            ret.add(pc);
            if (++count < n) continue;
            break;
        }
        return ret;
    }

    public static Matrix getDominantComponentsMatrix(List<PrincipleComponent> dom) {
        int nRows = dom.get((int)0).eigenVector.length;
        int nCols = dom.size();
        Matrix matrix = new Matrix(nRows, nCols);
        for (int col = 0; col < nCols; ++col) {
            for (int row = 0; row < nRows; ++row) {
                matrix.set(row, col, dom.get((int)col).eigenVector[row]);
            }
        }
        return matrix;
    }

    public int getNumComponents() {
        return this.eigenvalues.length;
    }

    public static double[][] getCovariance(double[][] input, double[] meanValues) {
        int j;
        int i;
        int numDataVectors = input.length;
        int n = input[0].length;
        double[] sum = new double[n];
        double[] mean = new double[n];
        for (i = 0; i < numDataVectors; ++i) {
            double[] vec = input[i];
            for (j = 0; j < n; ++j) {
                sum[j] = sum[j] + vec[j];
            }
        }
        for (i = 0; i < sum.length; ++i) {
            mean[i] = sum[i] / (double)numDataVectors;
        }
        double[][] ret = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (j = i2; j < n; ++j) {
                double v;
                ret[i2][j] = v = PCA.getCovariance(input, i2, j, mean);
                ret[j][i2] = v;
            }
        }
        if (meanValues != null) {
            System.arraycopy(mean, 0, meanValues, 0, mean.length);
        }
        return ret;
    }

    private static double getCovariance(double[][] matrix, int colA, int colB, double[] mean) {
        double sum = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            double v1 = matrix[i][colA] - mean[colA];
            double v2 = matrix[i][colB] - mean[colB];
            sum += v1 * v2;
        }
        int n = matrix.length;
        double ret = sum / (double)(n - 1);
        return ret;
    }

    private static void bug(String what) {
        System.out.println(what);
    }

    public static class PrincipleComponent
    implements Comparable<PrincipleComponent> {
        public double eigenValue;
        public double[] eigenVector;

        public PrincipleComponent(double eigenValue, double[] eigenVector) {
            this.eigenValue = eigenValue;
            this.eigenVector = eigenVector;
        }

        @Override
        public int compareTo(PrincipleComponent o) {
            int ret = 0;
            if (this.eigenValue > o.eigenValue) {
                ret = -1;
            } else if (this.eigenValue < o.eigenValue) {
                ret = 1;
            }
            return ret;
        }

        public String toString() {
            return "Principle Component, eigenvalue: " + this.eigenValue + ", eigenvector: [" + Arrays.toString(this.eigenVector) + "]";
        }
    }
}

