/*
   BLAKE2 reference source code package - optimized C implementations

   Written in 2012 by Samuel Neves <sneves@dei.uc.pt>

   To the extent possible under law, the author(s) have dedicated all copyright
   and related and neighboring rights to this software to the public domain
   worldwide. This software is distributed without any warranty.

   You should have received a copy of the CC0 Public Domain Dedication along with
   this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.
*/
#pragma once
#ifndef __BLAKE2B_COMPRESS_REGS_H__
#define __BLAKE2B_COMPRESS_REGS_H__

static int blake2b_compress( blake2b_state *S, const uint8_t block[BLAKE2B_BLOCKBYTES] )
{
    const uint64_t m0  = load64(&block[0]);
    const uint64_t m1  = load64(&block[8]);
    const uint64_t m2  = load64(&block[16]);
    const uint64_t m3  = load64(&block[24]);
    const uint64_t m4  = load64(&block[32]);
    const uint64_t m5  = load64(&block[40]);
    const uint64_t m6  = load64(&block[48]);
    const uint64_t m7  = load64(&block[56]);
    const uint64_t m8  = load64(&block[64]);
    const uint64_t m9  = load64(&block[72]);
    const uint64_t m10 = load64(&block[80]);
    const uint64_t m11 = load64(&block[88]);
    const uint64_t m12 = load64(&block[96]);
    const uint64_t m13 = load64(&block[104]);
    const uint64_t m14 = load64(&block[112]);
    const uint64_t m15 = load64(&block[120]);

    uint64_t v0  = S->h[0];
    uint64_t v1  = S->h[1];
    uint64_t v2  = S->h[2];
    uint64_t v3  = S->h[3];
    uint64_t v4  = S->h[4];
    uint64_t v5  = S->h[5];
    uint64_t v6  = S->h[6];
    uint64_t v7  = S->h[7];
    uint64_t v8  = blake2b_IV[0];
    uint64_t v9  = blake2b_IV[1];
    uint64_t v10 = blake2b_IV[2];
    uint64_t v11 = blake2b_IV[3];
    uint64_t v12 = S->t[0] ^ blake2b_IV[4];
    uint64_t v13 = S->t[1] ^ blake2b_IV[5];
    uint64_t v14 = S->f[0] ^ blake2b_IV[6];
    uint64_t v15 = S->f[1] ^ blake2b_IV[7];

    v0 = v0 + v4 + m0;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m1;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m2;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m3;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m4;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m5;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m6;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m7;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m8;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m9;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m10;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m11;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m12;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m13;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m14;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m15;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m14;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m10;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m4;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m8;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m9;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m15;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m13;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m6;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m1;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m12;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m0;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m2;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m11;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m7;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m5;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m3;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m11;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m8;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m12;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m0;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m5;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m2;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m15;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m13;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m10;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m14;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m3;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m6;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m7;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m1;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m9;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m4;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m7;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m9;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m3;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m1;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m13;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m12;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m11;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m14;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m2;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m6;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m5;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m10;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m4;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m0;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m15;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m8;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m9;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m0;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m5;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m7;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m2;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m4;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m10;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m15;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m14;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m1;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m11;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m12;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m6;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m8;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m3;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m13;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m2;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m12;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m6;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m10;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m0;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m11;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m8;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m3;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m4;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m13;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m7;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m5;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m15;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m14;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m1;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m9;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m12;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m5;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m1;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m15;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m14;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m13;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m4;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m10;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m0;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m7;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m6;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m3;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m9;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m2;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m8;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m11;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m13;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m11;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m7;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m14;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m12;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m1;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m3;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m9;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m5;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m0;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m15;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m4;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m8;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m6;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m2;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m10;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m6;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m15;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m14;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m9;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m11;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m3;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m0;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m8;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m12;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m2;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m13;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m7;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m1;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m4;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m10;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m5;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m10;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m2;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m8;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m4;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m7;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m6;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m1;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m5;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m15;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m11;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m9;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m14;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m3;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m12;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m13;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m0;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m0;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m1;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m2;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m3;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m4;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m5;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m6;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m7;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m8;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m9;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m10;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m11;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m12;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m13;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m14;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m15;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);
    v0 = v0 + v4 + m14;
    v12 = rotr64(v12 ^ v0, 32);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 24);
    v0 = v0 + v4 + m10;
    v12 = rotr64(v12 ^ v0, 16);
    v8 = v8 + v12;
    v4 = rotr64(v4 ^ v8, 63);
    v1 = v1 + v5 + m4;
    v13 = rotr64(v13 ^ v1, 32);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 24);
    v1 = v1 + v5 + m8;
    v13 = rotr64(v13 ^ v1, 16);
    v9 = v9 + v13;
    v5 = rotr64(v5 ^ v9, 63);
    v2 = v2 + v6 + m9;
    v14 = rotr64(v14 ^ v2, 32);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 24);
    v2 = v2 + v6 + m15;
    v14 = rotr64(v14 ^ v2, 16);
    v10 = v10 + v14;
    v6 = rotr64(v6 ^ v10, 63);
    v3 = v3 + v7 + m13;
    v15 = rotr64(v15 ^ v3, 32);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 24);
    v3 = v3 + v7 + m6;
    v15 = rotr64(v15 ^ v3, 16);
    v11 = v11 + v15;
    v7 = rotr64(v7 ^ v11, 63);
    v0 = v0 + v5 + m1;
    v15 = rotr64(v15 ^ v0, 32);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 24);
    v0 = v0 + v5 + m12;
    v15 = rotr64(v15 ^ v0, 16);
    v10 = v10 + v15;
    v5 = rotr64(v5 ^ v10, 63);
    v1 = v1 + v6 + m0;
    v12 = rotr64(v12 ^ v1, 32);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 24);
    v1 = v1 + v6 + m2;
    v12 = rotr64(v12 ^ v1, 16);
    v11 = v11 + v12;
    v6 = rotr64(v6 ^ v11, 63);
    v2 = v2 + v7 + m11;
    v13 = rotr64(v13 ^ v2, 32);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 24);
    v2 = v2 + v7 + m7;
    v13 = rotr64(v13 ^ v2, 16);
    v8 = v8 + v13;
    v7 = rotr64(v7 ^ v8, 63);
    v3 = v3 + v4 + m5;
    v14 = rotr64(v14 ^ v3, 32);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 24);
    v3 = v3 + v4 + m3;
    v14 = rotr64(v14 ^ v3, 16);
    v9 = v9 + v14;
    v4 = rotr64(v4 ^ v9, 63);

    S->h[0] ^= v0 ^  v8;
    S->h[1] ^= v1 ^  v9;
    S->h[2] ^= v2 ^ v10;
    S->h[3] ^= v3 ^ v11;
    S->h[4] ^= v4 ^ v12;
    S->h[5] ^= v5 ^ v13;
    S->h[6] ^= v6 ^ v14;
    S->h[7] ^= v7 ^ v15;

    return 0;
}

#endif
