#   pybuilder_release_plugin
#   Copyright 2014 Michael Gruber
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

from pybuilder.core import task, depends, description
from subprocess import check_call


@task("release")
@depends("publish")
@description("Releasing your project using committer")
def release(project, logger):
    project_version = project.version
    logger.info("Releasing version {version}".format(version=project_version))

    check_call(["ci", "v{version}".format(version=project_version)])
    check_call(["git", "tag", "v{version}".format(version=project_version)])
    check_call(["git", "push", "--tags"])

    working_directory = "target/dist/{name}-{version}".format(name=project.name, version=project_version)
    check_call(["./setup.py", "sdist", "upload"], cwd=working_directory)
    check_call(["./setup.py", "bdist_wheel", "upload"], cwd=working_directory)
