# -*- coding: utf-8 -*-

"""
PyCompta

Ce module définit les postes du compte de résultat et du bilan.
"""

__revision__ = "$Id: definitions.py,v 1.21 2005-09-29 15:42:29 nico Exp $"

# COMPTE RESULTAT ##############################################################

### FIXME: La variation de stocks (comptes 603,713) n'est pas prise en compte
### dans le calcul des charges et des produits

CHARGES = [
    (u"1.1", u"Charges d'exploitation",
     [],
     [(u"1.1.1", u'Achats de marchandises',
       [(u'607', None),
        (u'6097', None)],
       []),
      (u"1.1.2", u'Achats de matière première et autres approvisionnements',
       [(u'601', None),
        (u'602', None),
        (u'6091', None),
        (u'6092', None)],
       []),
      (u"1.1.3", u'Autres achats et charges externes',
       [(u'604', None),
        (u'605', None),
        (u'606', None),
        (u'608', None),
        (u'6093', None),
        (u'6094', None),
        (u'6095', None),
        (u'6096', None),
        (u'6098', None),
        (u'6099', None),
        (u'61', None),
        (u'62', None)],
       []),
      (u"1.1.4", u'Impôts taxes et versements assimilés',
       [(u'63', None)],
       []),
      (u"1.1.5", u'Salaires et traitements',
       [(u'641', None),
        (u'642', None),
        (u'644', None)],
       []),
      (u"1.1.6", u'Charges sociales',
       [(u'645', None),
        (u'646', None),
        (u'647', None),
        (u'648', None)],
       []),
      (u"1.1.7", u'Dotations aux amortissements',
       [(u'6811', None),
        (u'6812', None)],
       []),
      (u"1.1.7b", u'Dotations aux provisions',
       [(u'6815', None),
        (u'6816', None),
        (u'6817', None)],
       []),
      (u"1.1.8", u'Autres charges',
       [(u'651', None),
        (u'653', None),
        (u'654', None),
        (u'658', None)],
       []),
      ]),
    (u"1.2", u"Quote-part de résultat sur opérations faites en commun (pertes)",
     [(u'655',None)],
     []),
    (u"1.3", u"Charges financières",
     [],
     [(u"1.3.1", u'Dotations aux amortissements et aux provisions',
       [(u'686',None)],
       []),
      (u"1.3.2", u'Intérêts et charges assimilées',
       [(u'661',None),
        (u'664',None),
        (u'665',None),
        (u'668',None)],
       []),
      (u"1.3.3", u'Différences négatives de change',
       [(u'666',None)],
       []),
      (u"1.3.4", u'Charges nettes sur cession de valeurs mobilières de placement',
       [(u'667',None)],
       []),
      ]),
    (u"1.4", u"Charges exceptionnelles",
     [],
     [(u"1.4.1", u'Sur opérations de gestion',
       [(u'671',None),
        (u'672',None)], # certain ?
       []),
      (u"1.4.2", u'Sur opérations en capital',
       [(u'675',None),
        (u'678',None)],
       []),
      (u"1.4.3", u'Dotations aux amortissements et aux provisions',
       [(u'687',None)],
       []),
      ]),
    (u"1.5", u"Participation des salariés",
     [(u'691',None)],
     []),
    (u"1.6", u"Impôts sur les bénéfices",
     [(u'695',None),
      (u'697',None),
      (u'699',None)],
     []),
    ]

PRODUITS = [
    (u"2.1", u"Produits d'exploitation",
     [],
     [(u"2.1.2", u"Chiffre d'affaires",
       [],
       [(u"2.1.2.1", u'Ventes de marchandises',
         [(u'707', None),
          (u'7097',None)],
         []),
        (u"2.1.2.2", u'Production vendue (biens)',
         [(u'701',None),
          (u'702',None),
          (u'703',None),
          (u'7091',None),
          (u'7092',None),
          (u'7093',None),],
         []),
        (u"2.1.2.3", u'Production vendue (services)',
         [(u'704',None),
          (u'705',None),
          (u'706',None),
          (u'708',None),
          (u'7094',None),
          (u'7095',None),
          (u'7096',None),
          (u'7098',None),],
         []),
        ]),
      (u"2.1.6", u"Production stockée",
       [(u'71', None)],
       []),
      (u"2.1.7", u"Production immobilisée",
       [(u'72', None)],
       []),
      (u"2.1.3", u"Subventions d'exploitation",
       [(u'74', None)],
       []),
      (u"2.1.4", u"Reprises sur provisions et amortissements, transferts de charges",
       [(u'781', None),
        (u'791',None)],
       []),
      (u"2.1.5", u'Autres produits',
       [(u'751', None),
        (u'752',None),
        (u'753',None),
        (u'758',None)],
       []),
      ]),
    (u"2.2", u"Quote-part de résultat sur opérations faites en commun (bénéfices)",
     [(u'755',None)],
     []),
    (u"2.3", u"Produits financiers",
     [],
     [(u"2.3.1", u'De participation',
       [(u'761',None)],
       []),
      (u"2.3.2", u"D'autres valeurs mobilières et créances de l'actif immobilisé",
       [(u'762',None)],
       []),
      (u"2.3.3", u'Autres intérêts et produits assimilés',
       [(u'763',None),
        (u'764',None),
        (u'765',None),
        (u'768',None)],
       []),
      (u"2.3.4", u'Reprises sur provisions et transferts de charges',
       [(u'786',None),
        (u'796',None)],
       []),
      (u"2.3.5", u'Différences positives de change',
       [(u'766',None)],
       []),
      (u"2.3.6", u'Produits nets sur cession de valeurs mobilières de placement',
       [(u'767',None)],
       []),
      ]),
    (u"2.4", u'Produits exceptionnels',
     [],
     [(u"2.4.1", u'Sur opérations de gestion',
       [(u'771',None),
        (u'772',None),
        (u'778',None),],
       []),
      (u"2.4.2", u'Sur opérations en capital',
       [(u'775',None),
        (u'777',None),],
       []),
      (u"2.4.3", u'Reprises sur provisions et transferts de charges',
       [(u'787',None),
        (u'797',None)],
       []),
      ])
    ]


# BILAN ########################################################################

# XXXFIXME d'une manière générale, tous les comptes 4 doivent apparaître dans
# Actif circulant ou dettes
# suivant qu'ils sont créditeurs ou débiteurs, ils vont d'un côté ou de l'autre
# s'ils sont dans l'autre sens, on inverse...

ACTIF = [
    (u"3.1", u'Actif immobilisé',
     [], [],
     [(u'3.1.1', u'Immobilisations incorporelles',
       [], [],
       [(u'3.1.1.1', u"Frais d'établissement",
         [(u'201', None)], [(u'2801', None)],
         []),
        (u'3.1.1.2', u'Frais de R&D',
         [(u'203', None)], [(u'2803', None)],
         []),
        (u'3.1.1.3', u'Concessions, brevets, etc.',
         [(u'205', None)], [(u'2805', None)],
         []),
        (u'3.1.1.4', u'Fonds commercial',
         [(u'206', None),
          (u'207', None)],
         [(u'2806', None),
          (u'2807', None)],
         []),
        (u'3.1.1.5', u'Autres',
         [(u'208', None)], [(u'2808', None)],
         []),
        (u'3.1.1.6', u'Avances et acomptes',
         [(u'237', None)], [(u'2837', None)],
         []),
        ]),
      (u'3.1.2', u'Immobilisations corporelles',
       [], [],
       [(u'3.1.2.1', u'Terrains',
         [(u'211', None),
          (u'212', None)],
         [(u'2811', None),
          (u'2812', None)],
         []),
        (u'3.1.2.2', u'Constructions',
         [(u'213', None),
          (u'214', None)],
         [(u'2813', None),
          (u'2814', None)],
         []),
        (u'3.1.2.3', u'Installations techniques, matériel et outillage industriels',
         [(u'215', None)], [(u'2815', None)],
         []),
        (u'3.1.2.4', u'Autres',
         [(u'218', None)], [(u'2818', None)],
         []),
        (u'3.1.2.5', u'Immobilisations corporelles en cours',
         [(u'231', None)], [(u'2831', None)],
         []),
        (u'3.1.2.6', u'Avances et acomptes',
         [(u'238', None)], [(u'2838', None)],
         []),
        ]),
      (u'3.1.3', u'Immobilisations financières',
       [], [],
       [(u'3.1.3.1', u'Participations',
         [(u'261', None),
          (u'268', None)],
         [(u'2861', None),
          (u'2868', None)],
         []),
        (u'3.1.3.2', u'Créances rattachées',
         [(u'267', None),
          (u'268', None)],
         [(u'2867', None),
          (u'2868', None)],
         []),
        (u'3.1.3.3', u'Autres titres immobilisés',
         [(u'271', None),
          (u'272', None)],
         [(u'2871', None),
          (u'2872', None)],
         []),
        (u'3.1.3.4', u'Prêts',
         [(u'274', None)],   [(u'2874', None)],
         []),
        (u'3.1.3.5', u'Autres',
         [(u'275', None),
          (u'276', None)],
         [(u'2875', None),
          (u'2876', None)],
         []),
        ]),
      ]),
    (u'3.2', u'Actif circulant',
     [], [],
     [(u'3.2.1', u'Stocks et en-cours',
       [(u'3', None)], [], # XXX compter en brut/amort les debits/credits
       []),
      (u'3.2.2', u'Avances et acomptes versés',
       [(u'4091', None)], [],
       []),
      (u'3.2.3', u'Créances',
       [], [],
       [(u'3.2.3.1', u'Créances clients et comptes rattachés',
         [(u'411', None),
          (u'413', None),
          (u'416', None),
          (u'418', None)],
         [(u'491', None)],
         []),
        (u'3.2.3.2', u'Autres',
         [(u'4096', None),
          (u'4097', None),
          (u'4098', None),
          (u'425', None),
          (u'428', 'D'),
          (u'438', 'D')],
         [],
         []),
        (u'3.2.3.3', u'Créances diverses',
         [(u'4411', None),
          (u'4417', None),
          (u'4418', None),
          (u'4419', 'D'),
          (u'443', 'D'),
          (u'444', 'D'),
          (u'445', 'D'),
          (u'447', 'D'),
          (u'448', 'D'),
          (u'451', 'D'),
          (u'456', 'D'),
          (u'458', 'D'),
          (u'462', None),
          (u'465', None),
          (u'467', 'D'),
          (u'468', 'D'),
          (u'47', 'D')],
         [(u'496', None)],
         []),
        (u'3.2.3.4', u'Capital souscrit appelé, non versé',
         [(u'4562', None)], [],
         []),
        ]),
      (u'3.2.4', u'Valeurs mobilières de placement',
       [], [],
       [(u'3.2.4.1', u'Actions propres',
         [(u'502',None)], [],
         []),
        (u'3.2.4.2', u'Autres',
         [(u'503', None),
          (u'504', None),
          (u'505', None),
          (u'506', None),
          (u'507', None),
          (u'508', None),
          (u'590', None)],
         [],
         []),
        ]),
      (u'3.2.5', u'Disponibilités',
       [(u'511', 'D'),
        (u'512', 'D'),
        (u'514', None),
        (u'515', None),
        (u'516', None),
        (u'517', 'D'),
        (u'518', 'D'),
        (u'519', 'D'),
        (u'53', None),
        (u'54', None)],
       [],
       []),
      ]),
    (u'3.3', u'Régularisation',
     [], [],
     [(u'3.3.1', u"Charges constatées d'avance",
       [(u'486', None)], [],
       []),
      (u'3.3.2', u'Charges à répartir sur plusieurs exercices',
       [(u'481', None)], [],
       []),
      (u'3.3.3', u'Primes de remboursement des obligations',
       [(u'169', None)], [],
       []),
      #(u'Écarts de conversion Actif',
      # [(u'476', None)],
      # []),
      ]),
    ]

PASSIF = [
    (u'4.1', u'Capitaux propres',
     [],
     [(u'4.1.1', u'Capital',
       [(u'101', None)],
       []),
      (u'4.1.2', u"Primes d'émissions, de fusion, d'apport",
       [(u'104',None)],
       []),
      (u'4.1.3', u'Écarts de réévaluation',
       [(u'105',None)],
       []),
      (u'4.1.4', u'Réserve légale',
       [(u'1061',None)],
       []),
      (u'4.1.5', u'Réserves statutaires ou contractuelles',
       [(u'1063',None)],
       []),
      (u'4.1.6', u'Réserves réglementées',
       [(u'1062',None),
        (u'1064',None)],
       []),
      (u'4.1.7', u'Autres réserves',
       [(u'1068',None)],
       []),
      (u'4.1.8', u'Report à nouveau',
       [(u'11', None)],
       []),
      (u'4.1.9', u"Résultat de l'exercice",
       [(u'12', None)],
       []),
      (u'4.1.10', u"Subventions d'investissements",
       [(u'13', None)],
       []),
      (u'4.1.11', u'Provisions réglementées',
       [(u'14', None)],
       []),
      ]),
    (u'4.2', u'Provisions pour risques et charges',
     [],
     [(u'4.2.1', u'Provisions pour risques',
       [(u'151', None)],
       []),
      (u'4.2.2', u'Provisions pour charges',
       [(u'153', None),
        (u'155', None),
        (u'156', None),
        (u'157', None),
        (u'158', None)],
       []),
      ]),
    (u'4.3', u'Dettes',
     [],
     [(u'4.3.1', u'Emprunts obligataires convertibles',
       [(u'161', None)],
       []),
      (u'4.3.2', u'Autres emprunts obligataires',
       [(u'163', None)],
       []),
      (u'4.3.3', u'Emprunts et dettes auprès des établissements de crédit',
       [(u'164', None),
        (u'511', 'C'),
        (u'512', 'C'),
        (u'517', 'C'),
        (u'518', 'C'),
        (u'519', 'C')],
       []),
      (u'4.3.4', u'Emprunts et dettes financières diverses',
       [(u'165', None),
        (u'166', None),
        (u'167', None),
        (u'168', None),
        (u'171', None),
        (u'174', None),
        (u'178', None),
        (u'426', None),
        (u'451', 'C'), 
        (u'455', 'C'),
        (u'456', 'C'),
        (u'458', 'C')],
       []),
      (u'4.3.5', u'Avances et acomptes reçus',
       [(u'419', None),
        (u'4419', 'C')],
       []),
      (u'4.3.6', u'Dettes fournisseurs et comptes rattachés',
       [(u'401', None),
        (u'403', None),
        (u'408', None)],
       []),
      (u'4.3.7', u'Dettes fiscales et sociales',
       [(u'421', None),
        (u'422', None),
        (u'423', None),
        (u'424', None),
        (u'427', None),
        (u'428', 'C'),
        (u'431', None),
        (u'437', None),
        (u'438', 'C'),
        (u'442', None),
        (u'443', 'C'),
        (u'444', 'C'),
        (u'445', 'C'),
        (u'446', None),
        (u'447', 'C'),
        (u'448', 'C'),
        (u'457', None)],
       []),
      (u'4.3.8', u'Dettes sur immobilisations',
       [(u'269', None),
        (u'279', None),
        (u'404', None),
        (u'405', None),
        #              (u'408', None),
        ],
       []),
      (u'4.3.9', u"Autres dettes d'exploitation",
       [(u'4196', None),
        (u'4198', None),
        (u'464', None),
        (u'467', 'C'),
        (u'468', 'C'),
        (u'47', 'C'),
        (u'509', None)],
       []),
      ]),
    (u'4.4', u'Régularisation',
     [],
     [(u'4.4.1', u"Produits constatés d'avance",
       [(u'487', None)],
       []),
      #(u'Ecarts de conversion-passif',
      # [(u'477', None)],
      # []),
      ]),
    ]


# IMMOBILISATIONS

IMMO_AMORT = [
    (u'5.1', u'Incorporelles',
     [],
     [],
     [(u'5.1.1', u'Frais d\'établissement et de développement',
       [(u'201', None)],
       [(u'2801', None)],
       []),
      (u'5.1.2', u'Autres',
       [(u'203', None),
        (u'205', None),
        (u'206', None),
        (u'207', None),
        (u'208', None),
        ],
       [(u'2803', None),
        (u'2805', None),
        (u'2806', None),
        (u'2807', None),
        (u'2808', None),
        ],
       []),
      ]),
    (u'5.2', u'Corporelles',
     [],
     [],
     [(u'5.2.1', u'Terrains',
       [(u'211', None),
        (u'212', None),
        ],
       [(u'2811', None),
        (u'2812', None),
        ],
       []),
      (u'5.2.2', u'Constructions',
       [(u'213', None),
        (u'214', None),
        ],
       [(u'2813', None),
        (u'2814', None),
        ],
       []),
      (u'5.2.3', u'Installations techniques',
       [(u'215', None),
        ],
       [(u'2815', None),
        ],
       []),
      (u'5.2.4', u'Autres',
       [(u'218', None),
        (u'214', None),
        ],
       [(u'2818', None),
        (u'2814', None),
        ],
       []),
      (u'5.2.5', u'En cours',
       [(u'23', None),
        ],
       [(u'283', None),
        ],
       []),
      (u'5.2.6', u'Avances et acomptes',
       [(u'23', None),
        ],
       [(u'283', None),
        ],
       []),
      ]),
    (u'5.3', u'Financières',
     [],
     [],
     [(u'5.3.1', u'Participations évaluées par mise en équivalence',
       [(u'25', None),
        ],
       [(u'285', None),
        ],
       []),
      (u'5.3.2', u'Autres participations',
       [(u'26', None),
        ],
       [(u'286', None),
        ],
       []),
      (u'5.3.3', u'Autres titres immobilisés',
       [(u'26', None),
        ],
       [(u'286', None),
        ],
       []),
      (u'5.3.4', u'Prêtes et autres',
       [(u'27', None),
        ],
       [(u'287', None),
        ],
       []),
      ]),
    ]



