#!/usr/bin/env python

# setuptools plugin for darcs
# Author: Zooko O'Whielacronx

# Permission is hereby granted to any person obtaining a copy of this work to
# deal in this work without restriction (including the rights to use, modify,
# distribute, sublicense, and/or sell copies).

# See README.txt for instructions.

# Thanks to the authors of setuptools, setuptools_bzr, setuptools_git, and
# setuptools_mtn for documentation and examples.

import re

from setuptools import setup, find_packages

trove_classifiers=[
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: BSD License",
    "License :: DFSG approved",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

VERSIONFILE = "setuptools_darcs/_version.py"
verstr = "unknown"
VSRE = re.compile("^verstr = ['\"]([^'\"]*)['\"]", re.M)
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    mo = VSRE.search(verstrline)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("If %s.py exists, it is required to be well-formed." % (VERSIONFILE,))

setup(
    name='setuptools_darcs',
    version=verstr,
    description='setuptools plugin for darcs',
    author="Zooko O'Whielacronx",
    author_email='zooko@zooko.com',
    url='https://zooko.com/repos/setuptools_darcs',
    license='BSD',
    packages=find_packages(),
    include_package_data=True,
    classifiers=trove_classifiers,
    keywords='distutils setuptools setup darcs',
    entry_points={
        'setuptools.file_finders': [
            'darcs = setuptools_darcs.setuptools_darcs:find_files_for_darcs',
            ],
        },
    zip_safe=False, # I prefer unzipped for easier access.
    )
