#!/usr/bin/env python

# darcsver -- generate a version number from darcs history
# 
# Author: Zooko Wilcox-O'Hearn

# Permission is hereby granted to any person obtaining a copy of this work to
# deal in this work without restriction (including the rights to use, modify,
# distribute, sublicense, and/or sell copies).

import re

from setuptools import find_packages, setup

trove_classifiers=[
    "Development Status :: 5 - Production/Stable",
    "License :: OSI Approved :: BSD License",
    "License :: DFSG approved",
    "Intended Audience :: Developers", 
    "Operating System :: Microsoft",
    "Operating System :: Microsoft :: Windows",
    "Operating System :: Unix",
    "Operating System :: POSIX :: Linux",
    "Operating System :: POSIX",
    "Operating System :: MacOS :: MacOS X",
    "Operating System :: Microsoft :: Windows :: Windows NT/2000",
    "Operating System :: OS Independent", 
    "Natural Language :: English", 
    "Programming Language :: Python", 
    "Topic :: Utilities",
    "Topic :: Software Development :: Libraries",
    ]

VERSIONFILE = "darcsver/_version.py"
verstr = "unknown"
VSRE = re.compile("^verstr = ['\"]([^'\"]*)['\"]", re.M)
try:
    verstrline = open(VERSIONFILE, "rt").read()
except EnvironmentError:
    pass # Okay, there is no version file.
else:
    mo = VSRE.search(verstrline)
    if mo:
        verstr = mo.group(1)
    else:
        print "unable to find version in %s" % (VERSIONFILE,)
        raise RuntimeError("if %s.py exists, it must be well-formed" % (VERSIONFILE,))

setup(name='darcsver',
      version=verstr,
      description='generate a version number from darcs history',
      author='Zooko O\'Whielacronx',
      author_email='zooko@zooko.com',
      url='https://zooko.com/repos/darcsver',
      license='BSD',
      packages=find_packages(),
      include_package_data=True,
      classifiers=trove_classifiers,
      keywords='distutils setuptools setup darcs',
      entry_points = {
        'console_scripts': [ 'darcsver = scripts.darcsverscript:main' ],
        'distutils.commands': [ 'darcsver = darcsver.setuptools_command:DarcsVer', ],
        },
      zip_safe=False, # I prefer unzipped for easier access.
      )
