#!/usr/bin/env python
"""Unit tests for various imports.
"""

import unittest
import os
import pycscope
import sys

if sys.hexversion < 0x03000000:
    ellipsis_str = ". . ."
else:
    ellipsis_str = "..."


class TestImports(unittest.TestCase):

    def setUp(self,):
        self.buf = []
        self.fnbuf = []
        self.maxDiff = None

    def testimports(self,):
        cwd = os.getcwd()
        fn = "imports.py"
        l = pycscope.parseFile(cwd, fn, self.buf, 0, self.fnbuf)
        self.assertEqual(l, len(self.buf))
        output = "".join(self.buf)
        self.assertEqual(output, "\n"
                         "\t@imports.py\n"
                         "\n"
                         "1 import \n"
                         "\t~abcd\n"
                         "\n"
                         "2 import \n"
                         "\t~abcd.efgh.ijkl\n"
                         "\n"
                         "3 import \n"
                         "\t~abcd\n"
                         " , \n"
                         "\t~efgh\n"
                         " , \n"
                         "\t~ijkl\n"
                         "\n"
                         "4 import \n"
                         "\t~abcd.e.f.g\n"
                         " , \n"
                         "\t~efgh.i.j.k\n"
                         " , \n"
                         "\t~ijkl.m.n.o\n"
                         "\n"
                         "5 import \n"
                         "\t~abc\n"
                         " as \n"
                         "xyz\n"
                         "\n"
                         "6 import \n"
                         "\t~abc.x.y.z\n"
                         " as \n"
                         "xyz\n"
                         "\n"
                         "7 import \n"
                         "\t~abcd\n"
                         " as \n"
                         "xyz\n"
                         " , \n"
                         "\t~efg.h\n"
                         " as \n"
                         "uvw\n"
                         " , \n"
                         "\t~ghi.j.k.l\n"
                         " as \n"
                         "rst\n"
                         "\n"
                         "9 from \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         "\n"
                         "10 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import \n"
                         "xyz\n"
                         "\n"
                         "11 from \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         " , \n"
                         "uvw\n"
                         " , \n"
                         "rst\n"
                         "\n"
                         "12 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import \n"
                         "xyz\n"
                         " , \n"
                         "uvw\n"
                         " , \n"
                         "rst\n"
                         "\n"
                         "14 from \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         " as \n"
                         "uvw\n"
                         "\n"
                         "15 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import \n"
                         "xyz\n"
                         " as \n"
                         "uvw\n"
                         "\n"
                         "16 from \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         " as \n"
                         "zyx\n"
                         " , \n"
                         "uvw\n"
                         " as \n"
                         "wvu\n"
                         " , \n"
                         "rst\n"
                         " as \n"
                         "tsr\n"
                         "\n"
                         "17 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import \n"
                         "xyz\n"
                         " , \n"
                         "uvw\n"
                         " , \n"
                         "rst\n"
                         "\n"
                         "18 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import \n"
                         "xyz\n"
                         " , \n"
                         "uvw\n"
                         " , \n"
                         "rst\n"
                         " as \n"
                         "tsr\n"
                         "\n"
                         "20 from \n"
                         "\t~abc\n"
                         " import *\n"
                         "\n"
                         "21 from \n"
                         "\t~abcd.ef.ghi\n"
                         " import *\n"
                         "\n"
                         "23 from . import \n"
                         "xyz\n"
                         "\n"
                         "24 from . \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         "\n"
                         "25 from . . \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         "\n"
                         "26 from %s \n"
                         "\t~abc\n"
                         " import \n"
                         "xyz\n"
                         "\n" % ellipsis_str)
