#!/usr/bin/python
# -*- coding: utf-8 -*-
#This file is part of pydsl.
#
#pydsl is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#pydsl is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with pydsl.  If not, see <http://www.gnu.org/licenses/>.

__author__ = "Nestor Arocha"
__copyright__ = "Copyright 2008-2014, Nestor Arocha"
__email__ = "nesaro@gmail.com"

import logging
LOG = logging.getLogger(__name__)

def lcs(list1, list2):
    import difflib
    differences = difflib.SequenceMatcher(None, list1, list2)
    return [x for x in differences.get_matching_blocks()]

def diff_factory(definition):
    from pydsl.Alphabet import Alphabet
    if isinstance(definition, Alphabet):
        return lcs
    raise ValueError

def diff(definition, element1, element2):
    return diff_factory(definition)(element1, element2)
