/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class RayleighRandomVariable
extends AbstractContinuousRandomVariable {
    private double scale;

    public RayleighRandomVariable() {
        this(1.0);
    }

    public RayleighRandomVariable(double s) {
        this(s, new RandomRNG());
    }

    public RayleighRandomVariable(double s, RNG source) {
        super(source);
        this.setScale(s);
    }

    public static double nextRandomVariable(double s, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0) {
        }
        return Math.sqrt(-2.0 * Math.log(u)) * s;
    }

    private double getScale() {
        return this.scale;
    }

    public double nextRandomVariable() {
        return RayleighRandomVariable.nextRandomVariable(this.getScale(), this.getSource());
    }

    private void setScale(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = b;
    }
}

