/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class WeibullDistribution
extends ContinuousDistribution {
    private double location;
    private double scale;
    private double shape;

    public WeibullDistribution() {
        this(1.0, 1.0, 0.0);
    }

    public WeibullDistribution(double sh, double sc) {
        this(sh, sc, 0.0);
    }

    public WeibullDistribution(double sh, double sc, double l) {
        this.setShape(sh);
        this.setScale(sc);
        this.setLocation(l);
    }

    public double cumulativeProbability(double x) {
        double ret = Double.isNaN(x) ? Double.NaN : (x <= this.getLocation() ? 0.0 : (Double.isInfinite(x) ? 1.0 : 1.0 - Math.exp(-Math.pow((x - this.getLocation()) / this.getScale(), this.getShape()))));
        return ret;
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double inverseCumulativeProbability(double p) {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? this.getLocation() : (p == 1.0 ? Double.POSITIVE_INFINITY : this.getScale() * Math.pow(-Math.log(1.0 - p), 1.0 / this.getShape()) + this.getLocation()));
        return ret;
    }

    public void setLocation(double l) {
        if (Double.isNaN(l)) {
            throw new IllegalArgumentException("location parameter must be a number.");
        }
        this.location = l;
    }

    public void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale parameter must be positive.");
        }
        this.scale = s;
    }

    public void setShape(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("shape parameter must be positive.");
        }
        this.shape = s;
    }
}

