/*
 * Decompiled with CFR 0.152.
 */
package org.mangosdk.spi.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.mangosdk.spi.processor.Initializer;
import org.mangosdk.spi.processor.LogLocation;
import org.mangosdk.spi.processor.Logger;
import org.mangosdk.spi.processor.ServiceFileFilter;
import org.mangosdk.spi.processor.ServiceFileInitializer;

class Persistence {
    private final String name;
    private final String path;
    final Filer filer;
    final Logger logger;

    Persistence(String name, String root, Filer filer, Logger logger) {
        this.name = name;
        this.logger = logger;
        this.path = root + "META-INF/services/";
        this.filer = filer;
    }

    void writeLog() {
        try {
            String logContent = this.logger.getFileContent();
            if (logContent != null && !logContent.isEmpty()) {
                this.write("log" + System.currentTimeMillis() + ".log", logContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    Collection<String> tryFind() {
        File dir = this.determineOutputLocation();
        Collection<String> fileList = dir == null ? Collections.emptyList() : this.listDiscoveredServiceFiles(dir.listFiles(ServiceFileFilter.INSTANCE));
        return fileList;
    }

    private Collection<String> listDiscoveredServiceFiles(File[] list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : list) {
            String fileName = file.getName();
            this.logger.note(LogLocation.LOG_FILE, "Discovered " + fileName);
            result.add(fileName);
        }
        return result;
    }

    private File determineOutputLocation() {
        FileObject resource;
        try {
            resource = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path + "locator");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            this.logger.note(LogLocation.MESSAGER, "IOException while determining output location: " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        URI uri = resource.toUri();
        if (uri.isAbsolute()) {
            return new File(uri).getParentFile();
        }
        return new File(uri.toString()).getParentFile();
    }

    Initializer getInitializer() {
        return new ServiceFileInitializer(this.filer, this.path, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(String serviceName, String value) throws IOException {
        this.logger.note(LogLocation.BOTH, "Generating file '" + this.path + serviceName + "'");
        FileObject output = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.path + serviceName, new Element[0]);
        Writer writer = output.openWriter();
        try {
            writer.write("# Generated by " + this.name + "\n");
            writer.write("# " + new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(new Date()) + "\n");
            writer.write(value);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }
}

