/*
 * Decompiled with CFR 0.152.
 */
package de.congrace.exp4j;

import de.congrace.exp4j.CalculationToken;
import de.congrace.exp4j.CustomOperator;
import de.congrace.exp4j.FunctionToken;
import de.congrace.exp4j.Token;
import java.util.Map;
import java.util.Stack;

class OperatorToken
extends CalculationToken {
    CustomOperator operation;

    OperatorToken(String value, CustomOperator operation) {
        super(value);
        this.operation = operation;
    }

    double applyOperation(double ... values) {
        return this.operation.applyOperation(values);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperatorToken) {
            OperatorToken t = (OperatorToken)obj;
            return t.getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    void mutateStackForCalculation(Stack<Double> stack, Map<String, Double> variableValues) {
        double[] operands = new double[this.operation.operandCount];
        for (int i = 0; i < this.operation.operandCount; ++i) {
            operands[this.operation.operandCount - i - 1] = stack.pop();
        }
        stack.push(this.operation.applyOperation(operands));
    }

    @Override
    void mutateStackForInfixTranslation(Stack<Token> operatorStack, StringBuilder output) {
        Token before;
        while (!operatorStack.isEmpty() && (before = operatorStack.peek()) != null && (before instanceof OperatorToken || before instanceof FunctionToken)) {
            if (before instanceof FunctionToken) {
                operatorStack.pop();
                output.append(before.getValue()).append(" ");
                continue;
            }
            OperatorToken stackOperator = (OperatorToken)before;
            if (this.isLeftAssociative() && this.getPrecedence() <= stackOperator.getPrecedence()) {
                output.append(operatorStack.pop().getValue()).append(" ");
                continue;
            }
            if (this.isLeftAssociative() || this.getPrecedence() >= stackOperator.getPrecedence()) break;
            output.append(operatorStack.pop().getValue()).append(" ");
        }
        operatorStack.push(this);
    }

    private boolean isLeftAssociative() {
        return this.operation.leftAssociative;
    }

    private int getPrecedence() {
        return this.operation.precedence;
    }
}

