/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactoryOptions;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateFactory;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.aclib.fanova.FanovaRemote;
import net.aclib.fanova.IPCMechanism;
import net.aclib.fanova.model.FunctionalANOVAModelBuilder;
import net.aclib.fanova.model.FunctionalANOVARunner;
import net.aclib.fanova.model.FunctionalANOVAVarianceDecompose;
import net.aclib.fanova.options.FAnovaOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FAnovaExecutor {
    private static Logger log;

    public static void main(String[] args) {
        String outputDir = "";
        try {
            SeedableRandomPool pool = null;
            try {
                double quantile;
                JCommander jcom;
                FAnovaOptions fanovaOpts = new FAnovaOptions();
                args = StateFactoryOptions.processScenarioStateRestore((String[])args);
                ScenarioOptions scenarioOptions = fanovaOpts.scenOpts;
                try {
                    jcom = JCommanderHelper.parseCheckingForHelpAndVersion((String[])args, (AbstractOptions)fanovaOpts);
                    String runGroupName = fanovaOpts.getRunGroupName();
                    scenarioOptions.makeOutputDirectory(runGroupName);
                    outputDir = String.valueOf(scenarioOptions.outputDirectory) + File.separator + runGroupName;
                    fanovaOpts.loggingOptions.initializeLogging(outputDir, fanovaOpts.seedOptions.numRun);
                }
                finally {
                    log = LoggerFactory.getLogger(FAnovaExecutor.class);
                }
                VersionTracker.logVersions();
                for (String name : jcom.getParameterFilesToRead()) {
                    log.info("Parsing (default) options from file: {} ", (Object)name);
                }
                if (fanovaOpts.rfOptions.logModel == null) {
                    switch (fanovaOpts.scenOpts.runObj) {
                        case RUNTIME: {
                            fanovaOpts.rfOptions.logModel = true;
                            break;
                        }
                        case QUALITY: {
                            fanovaOpts.rfOptions.logModel = false;
                        }
                    }
                }
                LegacyStateFactory sf = new LegacyStateFactory(null, fanovaOpts.stateFactoryOptions.restoreStateFrom);
                AlgorithmExecutionConfig execConfig = scenarioOptions.algoExecOptions.getAlgorithmExecutionConfigSkipDirCheck();
                ParamConfigurationSpace configSpace = execConfig.getParamFile();
                List instances = scenarioOptions.getTrainingAndTestProblemInstances(new File(".").getAbsolutePath(), 0L, 0L, true, false, false, false).getTrainingInstances().getInstances();
                ThreadSafeRunHistoryWrapper rh = new ThreadSafeRunHistoryWrapper((RunHistory)new NewRunHistory(scenarioOptions.intraInstanceObj, scenarioOptions.interInstanceObj, scenarioOptions.runObj));
                if (fanovaOpts.stateFactoryOptions.restoreIteration == null) {
                    throw new ParameterException("You must specify an iteration to restore");
                }
                StateDeserializer sd = sf.getStateDeserializer("it", fanovaOpts.stateFactoryOptions.restoreIteration.intValue(), configSpace, instances, execConfig, (RunHistory)rh);
                pool = fanovaOpts.seedOptions.getSeedableRandomPool();
                if (fanovaOpts.numTrainingSamples > 0) {
                    List algorithmRuns = rh.getAlgorithmRuns();
                    Integer[] indices = new Integer[algorithmRuns.size()];
                    int i = 0;
                    while (i < algorithmRuns.size()) {
                        indices[i] = i;
                        ++i;
                    }
                    List<Integer> shuffledIndices = Arrays.asList(indices);
                    Collections.shuffle(shuffledIndices, pool.getRandom("inputSubsample"));
                    ThreadSafeRunHistoryWrapper subsampledRH = new ThreadSafeRunHistoryWrapper((RunHistory)new NewRunHistory(scenarioOptions.intraInstanceObj, scenarioOptions.interInstanceObj, scenarioOptions.runObj));
                    int i2 = 0;
                    while (i2 < fanovaOpts.numTrainingSamples) {
                        subsampledRH.append((AlgorithmRun)algorithmRuns.get(shuffledIndices.get(i2)));
                        ++i2;
                    }
                    rh = subsampledRH;
                }
                FunctionalANOVAModelBuilder famb = new FunctionalANOVAModelBuilder();
                famb.learnModel(instances, (RunHistory)rh, configSpace, fanovaOpts.rfOptions, fanovaOpts.mbOptions, scenarioOptions, true, pool);
                boolean compareToDef = fanovaOpts.compare.equals((Object)FAnovaOptions.Improvements.DEFAULT);
                double d = quantile = fanovaOpts.compare.equals((Object)FAnovaOptions.Improvements.QUANTILE) ? fanovaOpts.quantileToCompare : -1.0;
                if (fanovaOpts.mode.equals("ipc")) {
                    FunctionalANOVAVarianceDecompose favd = new FunctionalANOVAVarianceDecompose(famb.getRandomForest(), rh.getAlgorithmRuns(), configSpace, pool.getRandom("FANOVA_BUILDER"), compareToDef, quantile, fanovaOpts.rfOptions.logModel);
                    FanovaRemote remote = new FanovaRemote(favd, new IPCMechanism("localhost", fanovaOpts.port), configSpace);
                    remote.run();
                } else {
                    FunctionalANOVARunner.decomposeVariance(famb.getRandomForest(), rh.getAlgorithmRuns(), configSpace, pool.getRandom("FANOVA_BUILDER"), compareToDef, quantile, fanovaOpts.computePairwiseInteration, outputDir, fanovaOpts.rfOptions.logModel, fanovaOpts.plotMarginals);
                }
            }
            finally {
                if (pool != null) {
                    pool.logUsage();
                }
            }
        }
        catch (ParameterException e) {
            System.out.println((Object)e);
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

