/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova;

import ca.ubc.cs.beta.aclib.configspace.NormalizedRange;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.aclib.fanova.IPCMechanism;
import net.aclib.fanova.model.FunctionalANOVAVarianceDecompose;

public class FanovaRemote {
    private FunctionalANOVAVarianceDecompose favd;
    private IPCMechanism ipc;
    private ParamConfigurationSpace configSpace;
    private HashMap<String, Integer> param2dim = new HashMap();

    public FanovaRemote(FunctionalANOVAVarianceDecompose favd, IPCMechanism ipc, ParamConfigurationSpace configSpace) {
        this.favd = favd;
        this.ipc = ipc;
        this.configSpace = configSpace;
        int i = 0;
        while (i < this.configSpace.getParameterNames().size()) {
            this.param2dim.put((String)this.configSpace.getParameterNames().get(i), i);
            ++i;
        }
    }

    public void run() {
        while (true) {
            String command;
            String msg;
            if ((msg = this.ipc.receive()) == null) {
                continue;
            }
            String[] commandAndArgs = new String[]{};
            if (msg.contains(":")) {
                commandAndArgs = msg.split(":");
                command = commandAndArgs[0];
            } else {
                command = msg;
            }
            if (command.equals("get_marginal")) {
                assert (commandAndArgs.length == 2);
                int dim = Integer.valueOf(commandAndArgs[1]);
                double marginal = this.favd.getMarginal(dim);
                this.ipc.send(String.valueOf(String.valueOf(marginal)) + "\n");
                continue;
            }
            if (command.equals("get_pairwise_marginal")) {
                assert (commandAndArgs.length == 3);
                int dim1 = Integer.valueOf(commandAndArgs[1]);
                int dim2 = Integer.valueOf(commandAndArgs[2]);
                double marginal = this.favd.getPairwiseMarginal(dim1, dim2);
                this.ipc.send(String.valueOf(String.valueOf(marginal)) + "\n");
                continue;
            }
            if (command.equals("die")) {
                System.out.println("QUITTING");
                return;
            }
            if (command.equals("unormalize_value")) {
                assert (commandAndArgs.length == 3);
                String parameterName = commandAndArgs[1];
                double normalizedValue = Double.valueOf(commandAndArgs[2]);
                if (this.configSpace.getNormalizedRangeMap().containsKey(parameterName)) {
                    NormalizedRange range = (NormalizedRange)this.configSpace.getNormalizedRangeMap().get(parameterName);
                    this.ipc.send(String.valueOf(range.unnormalizeValue(normalizedValue)) + "\n");
                    continue;
                }
                this.ipc.send("\n");
                continue;
            }
            if (command.equals("get_parameter_names")) {
                StringBuilder sb = new StringBuilder();
                for (String name : this.configSpace.getParameterNames()) {
                    name = name.replace(';', '_');
                    sb.append(name);
                    sb.append(';');
                }
                if (sb.length() != 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.ipc.send(String.valueOf(sb.toString()) + "\n");
                continue;
            }
            if (command.equals("get_categorical_parameters")) {
                StringBuilder sb = new StringBuilder();
                int[] categoricalSize = this.configSpace.getCategoricalSize();
                int i = 0;
                while (i < categoricalSize.length) {
                    if (categoricalSize[i] > 0) {
                        sb.append(((String)this.configSpace.getParameterNames().get(i)).replace(';', '_'));
                        sb.append(';');
                    }
                    ++i;
                }
                if (sb.length() != 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.ipc.send(String.valueOf(sb.toString()) + "\n");
                continue;
            }
            if (command.equals("get_categorical_size")) {
                assert (commandAndArgs.length == 2);
                String parameterName = commandAndArgs[1];
                int[] categoricalSize = this.configSpace.getCategoricalSize();
                if (this.param2dim.containsKey(parameterName)) {
                    int dim = this.param2dim.get(parameterName);
                    this.ipc.send(String.valueOf(categoricalSize[dim]) + "\n");
                    continue;
                }
                this.ipc.send("\n");
                continue;
            }
            if (command.equals("get_categorical_values")) {
                assert (commandAndArgs.length == 2);
                String parameterName = commandAndArgs[1];
                StringBuilder sb = new StringBuilder();
                Map valueMap = this.configSpace.getCategoricalValueMap();
                if (valueMap.containsKey(parameterName)) {
                    Map parameterValueMap = (Map)valueMap.get(parameterName);
                    Vector entries = new Vector(parameterValueMap.entrySet());
                    Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                        @Override
                        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                            return o1.getValue() - o2.getValue();
                        }
                    });
                    for (Map.Entry entry : entries) {
                        System.out.println(String.valueOf((String)entry.getKey()) + " " + entry.getValue());
                        sb.append((String)entry.getKey());
                        sb.append(';');
                    }
                    if (sb.length() != 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
                this.ipc.send(String.valueOf(sb.toString()) + "\n");
                continue;
            }
            if (command.equals("get_continuous_parameters")) {
                StringBuilder sb = new StringBuilder();
                int[] categoricalSize = this.configSpace.getCategoricalSize();
                Map normMap = this.configSpace.getNormalizedRangeMap();
                int i = 0;
                while (i < categoricalSize.length) {
                    String paramName = (String)this.configSpace.getParameterNames().get(i);
                    if (categoricalSize[i] == 0 && !((NormalizedRange)normMap.get(paramName)).isIntegerOnly()) {
                        sb.append(paramName.replace(';', '_'));
                        sb.append(';');
                    }
                    ++i;
                }
                if (sb.length() != 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.ipc.send(String.valueOf(sb.toString()) + "\n");
                continue;
            }
            if (command.equals("get_integer_parameters")) {
                StringBuilder sb = new StringBuilder();
                int[] categoricalSize = this.configSpace.getCategoricalSize();
                Map normMap = this.configSpace.getNormalizedRangeMap();
                int i = 0;
                while (i < categoricalSize.length) {
                    String paramName = (String)this.configSpace.getParameterNames().get(i);
                    if (categoricalSize[i] == 0 && ((NormalizedRange)normMap.get(paramName)).isIntegerOnly()) {
                        sb.append(paramName.replace(';', '_'));
                        sb.append(';');
                    }
                    ++i;
                }
                if (sb.length() != 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.ipc.send(String.valueOf(sb.toString()) + "\n");
                continue;
            }
            if (command.equals("get_marginal_for_value")) {
                assert (commandAndArgs.length == 3);
                int dim = Integer.valueOf(commandAndArgs[1]);
                double valueToPredict = Double.valueOf(commandAndArgs[2]);
                double[] meanAndStd = this.favd.getMarginalForValue(dim, valueToPredict);
                String send_msg = String.valueOf(meanAndStd[0]) + ";" + meanAndStd[1] + "\n";
                this.ipc.send(send_msg);
                continue;
            }
            if (!command.equals("get_marginal_for_value_pair")) continue;
            assert (commandAndArgs.length == 5);
            int dim1 = Integer.valueOf(commandAndArgs[1]);
            int dim2 = Integer.valueOf(commandAndArgs[2]);
            double valueToPredict1 = Double.valueOf(commandAndArgs[3]);
            double valueToPredict2 = Double.valueOf(commandAndArgs[4]);
            double[] meanAndStd = this.favd.getMarginalForValuePair(dim1, dim2, valueToPredict1, valueToPredict2);
            String send_msg = String.valueOf(meanAndStd[0]) + ";" + meanAndStd[1] + "\n";
            this.ipc.send(send_msg);
        }
    }
}

