/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova.eval;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.stat.descriptive.rank.Percentile;

public class ModelEvaluation {
    public static void main(String[] args) {
    }

    public static RandomForest extractMarginalForest(RandomForest forest, List<AlgorithmRun> testRuns, ParamConfigurationSpace configFile, Random rand, boolean compareToDefault, double quantileToCompareTo) {
        System.out.println("Extracing marginal forest from surrogateZip file.");
        HashSet<ProblemInstance> uniqInstances = new HashSet<ProblemInstance>();
        for (AlgorithmRun run : testRuns) {
            uniqInstances.add(run.getRunConfig().getProblemInstanceSeedPair().getInstance());
        }
        double[][] X = new double[uniqInstances.size()][];
        int i = 0;
        for (ProblemInstance pi : uniqInstances) {
            double[] featureArray = pi.getFeaturesDouble();
            X[i] = new double[featureArray.length];
            System.arraycopy(featureArray, 0, X[i], 0, featureArray.length);
            ++i;
        }
        int numParams = -1;
        HashSet<ParamConfiguration> uniqConfigurations = new HashSet<ParamConfiguration>();
        for (AlgorithmRun run : testRuns) {
            uniqConfigurations.add(run.getRunConfig().getParamConfiguration());
        }
        double[][] uniqTheta = new double[uniqConfigurations.size()][];
        i = 0;
        for (ParamConfiguration config : uniqConfigurations) {
            double[] valueArray = config.toValueArray();
            numParams = valueArray.length;
            uniqTheta[i] = valueArray;
            ++i;
        }
        RandomForest preparedForest = RandomForest.preprocessForest((RandomForest)forest, (double[][])X);
        RegtreeBuildParams regtreeBuildParamsNoFeatures = RegtreeBuildParams.copy((RegtreeBuildParams)forest.getBuildParams(), (int)numParams);
        Random r = new Random();
        r.setSeed(1234L);
        double[][] defaultThetaAsArray = new double[][]{configFile.getDefaultConfiguration().toValueArray()};
        double[][] newX = new double[1][0];
        int[][] theta_inst_idxs = new int[uniqTheta.length][2];
        int k = 0;
        while (k < uniqTheta.length) {
            theta_inst_idxs[k][0] = k;
            theta_inst_idxs[k][1] = 0;
            ++k;
        }
        int numRandomConfigs = 1000;
        ParamConfiguration[] randConfigs = new ParamConfiguration[numRandomConfigs];
        int num = 0;
        while (num < numRandomConfigs) {
            randConfigs[num] = configFile.getRandomConfiguration(r);
            ++num;
        }
        int[] treesToUse = new int[preparedForest.numTrees];
        int numTree = 0;
        while (numTree < preparedForest.numTrees) {
            treesToUse[numTree] = numTree;
            ++numTree;
        }
        double[][] forestMarginalPredictions = RandomForest.applyMarginal((RandomForest)preparedForest, (int[])treesToUse, (double[][])uniqTheta);
        double[] forestMarginalPredMean = new double[forestMarginalPredictions.length];
        int k2 = 0;
        while (k2 < forestMarginalPredMean.length) {
            forestMarginalPredMean[k2] = forestMarginalPredictions[k2][0];
            ++k2;
        }
        double quantileToBeat = 0.0;
        if (!compareToDefault && quantileToCompareTo > 0.0) {
            Percentile p = new Percentile();
            p.setData(forestMarginalPredMean);
            quantileToBeat = p.evaluate(quantileToCompareTo * 100.0);
            System.out.println("Quantile to beat: " + quantileToBeat);
        }
        RandomForest franksForest = new RandomForest(preparedForest.numTrees, regtreeBuildParamsNoFeatures);
        int b = 0;
        while (b < preparedForest.numTrees) {
            int[] treeToUse = new int[]{b};
            double[][] predictions = RandomForest.applyMarginal((RandomForest)preparedForest, (int[])treeToUse, (double[][])uniqTheta);
            double[][] defaultPerformanceArray = RandomForest.applyMarginal((RandomForest)preparedForest, (int[])treeToUse, (double[][])defaultThetaAsArray);
            double defaultPerformance = defaultPerformanceArray[0][0];
            double[] actualMarginalPred = new double[predictions.length];
            int k3 = 0;
            while (k3 < predictions.length) {
                actualMarginalPred[k3] = Math.pow(predictions[k3][0], 10.0);
                ++k3;
            }
            double[] myMarginalPred = new double[predictions.length];
            int k4 = 0;
            while (k4 < predictions.length) {
                myMarginalPred[k4] = compareToDefault ? Math.min(defaultPerformance, predictions[k4][0]) : (quantileToCompareTo > 0.0 ? Math.min(quantileToBeat, predictions[k4][0]) : predictions[k4][0]);
                ++k4;
            }
            RandomForest marginalForest = RandomForest.learnModel((int)1, (double[][])uniqTheta, (double[][])newX, (int[][])theta_inst_idxs, (double[])myMarginalPred, (RegtreeBuildParams)regtreeBuildParamsNoFeatures);
            franksForest.Trees[b] = marginalForest.Trees[0];
            ++b;
        }
        franksForest = RandomForest.preprocessForest((RandomForest)franksForest, (double[][])newX);
        return franksForest;
    }
}

