/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova.model;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.model.ModelBuildingOptions;
import ca.ubc.cs.beta.aclib.model.builder.AdaptiveCappingModelBuilder;
import ca.ubc.cs.beta.aclib.model.builder.BasicModelBuilder;
import ca.ubc.cs.beta.aclib.model.data.DefaultValueForConditionalsMDS;
import ca.ubc.cs.beta.aclib.model.data.MaskCensoredDataAsUncensored;
import ca.ubc.cs.beta.aclib.model.data.MaskInactiveConditionalParametersWithDefaults;
import ca.ubc.cs.beta.aclib.model.data.SanitizedModelData;
import ca.ubc.cs.beta.aclib.options.RandomForestOptions;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalANOVAModelBuilder {
    private RandomForest forest;
    private RandomForest preparedForest;
    private SanitizedModelData sanitizedData;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void learnModel(List<ProblemInstance> instances, RunHistory runHistory, ParamConfigurationSpace configSpace, RandomForestOptions rfOptions, ModelBuildingOptions mbOptions, ScenarioOptions scenarioOptions, boolean adaptiveCapping, SeedableRandomPool pool) {
        int j;
        LinkedHashSet<ProblemInstance> all_instances = new LinkedHashSet<ProblemInstance>(instances);
        Set paramConfigs = runHistory.getUniqueParamConfigurations();
        Set runInstances = runHistory.getUniqueInstancesRan();
        ArrayList<Integer> runInstancesIdx = new ArrayList<Integer>(all_instances.size());
        int i = 0;
        double[][] instanceFeatureMatrix = new double[all_instances.size()][];
        for (ProblemInstance pi : all_instances) {
            if (runInstances.contains(pi)) {
                runInstancesIdx.add(i);
            }
            instanceFeatureMatrix[i] = pi.getFeaturesDouble();
            ++i;
        }
        double[][] thetaMatrix = new double[paramConfigs.size()][];
        i = 0;
        for (ParamConfiguration pc : paramConfigs) {
            thetaMatrix[i++] = mbOptions.maskInactiveConditionalParametersAsDefaultValue ? pc.toComparisonValueArray() : pc.toValueArray();
        }
        int[] usedInstanceIdxs = new int[runInstancesIdx.size()];
        int j2 = 0;
        while (j2 < runInstancesIdx.size()) {
            usedInstanceIdxs[j2] = (Integer)runInstancesIdx.get(j2);
            ++j2;
        }
        double[] runResponseValues = runHistory.getRunResponseValues();
        boolean[] censored = runHistory.getCensoredFlagForRuns();
        if (mbOptions.maskCensoredDataAsKappaMax) {
            j = 0;
            while (j < runResponseValues.length) {
                if (censored[j]) {
                    runResponseValues[j] = scenarioOptions.algoExecOptions.cutoffTime;
                }
                ++j;
            }
        }
        j = 0;
        while (j < runResponseValues.length) {
            if (runResponseValues[j] >= scenarioOptions.algoExecOptions.cutoffTime) {
                runResponseValues[j] = scenarioOptions.algoExecOptions.cutoffTime * scenarioOptions.intraInstanceObj.getPenaltyFactor();
            }
            ++j;
        }
        DefaultValueForConditionalsMDS sanitizedData = new DefaultValueForConditionalsMDS((double[][])instanceFeatureMatrix, (double[][])thetaMatrix, runResponseValues, usedInstanceIdxs, rfOptions.logModel.booleanValue(), runHistory.getParameterConfigurationInstancesRanByIndex(), runHistory.getCensoredFlagForRuns(), configSpace);
        if (mbOptions.maskCensoredDataAsUncensored) {
            sanitizedData = new MaskCensoredDataAsUncensored((SanitizedModelData)sanitizedData);
        }
        if (mbOptions.maskInactiveConditionalParametersAsDefaultValue) {
            sanitizedData = new MaskInactiveConditionalParametersWithDefaults((SanitizedModelData)sanitizedData, configSpace);
        }
        this.forest = null;
        this.preparedForest = null;
        Object mb = adaptiveCapping ? new AdaptiveCappingModelBuilder((SanitizedModelData)sanitizedData, rfOptions, pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"), mbOptions.imputationIterations, scenarioOptions.algoExecOptions.cutoffTime, scenarioOptions.intraInstanceObj.getPenaltyFactor(), 1.0) : new BasicModelBuilder((SanitizedModelData)sanitizedData, rfOptions, 1.0, pool.getRandom("RANDOM_FOREST_BUILDING_PRNG"));
        this.forest = mb.getRandomForest();
        this.preparedForest = mb.getPreparedRandomForest();
        this.log.info("Random Forest Built");
    }

    public RandomForest getRandomForest() {
        return this.forest;
    }

    public RandomForest getPreparedForest() {
        return this.preparedForest;
    }
}

