/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova.model;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.Regtree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class RandomForestPreprocessor {
    public static void preprocessRandomForest(RandomForest forest, ParamConfigurationSpace configSpace) {
        Regtree[] trees;
        int[] categoricalSize = configSpace.getCategoricalSize();
        int dim = categoricalSize.length;
        boolean[] isCat = new boolean[dim];
        int i = 0;
        while (i < dim) {
            isCat[i] = categoricalSize[i] != 0;
            ++i;
        }
        HashSet[] catValues = new HashSet[dim];
        double[] contLB = new double[dim];
        double[] contUB = new double[dim];
        int i2 = 0;
        while (i2 < dim) {
            if (isCat[i2]) {
                catValues[i2] = new HashSet();
                int j = 0;
                while (j < categoricalSize[i2]) {
                    catValues[i2].add(new Integer(j));
                    ++j;
                }
            } else {
                contLB[i2] = 0.0;
                contUB[i2] = 1.0;
            }
            ++i2;
        }
        Regtree[] regtreeArray = trees = forest.Trees;
        int n = trees.length;
        int n2 = 0;
        while (n2 < n) {
            Regtree tree = regtreeArray[n2];
            tree.precomputeLeafInfo(isCat, catValues, contLB, contUB);
            ++n2;
        }
    }

    public static double computeTotalVarianceOfRegressionTree(Regtree regtree, ParamConfigurationSpace configSpace) {
        HashSet<Integer> allVariableIndices = new HashSet<Integer>();
        int j = 0;
        while (j < configSpace.getCategoricalSize().length) {
            allVariableIndices.add(new Integer(j));
            ++j;
        }
        double totalVariance = regtree.computeTotalVariance(null, null, allVariableIndices);
        System.out.println("Total variance of predictor (broken computation, only works in absence of instance features): " + totalVariance);
        return totalVariance;
    }

    public static HashMap<Integer, Double> getUpToKaryVarianceContributions(Regtree regtree, ParamConfigurationSpace configSpace, int k) {
        if (k > 4) {
            throw new IllegalArgumentException("Computation of k-ary variance contributions only implemented for K up to 4.");
        }
        HashMap<Integer, Double> singleVarianceContributions = new HashMap<Integer, Double>();
        int[] indicesOfObservations = new int[]{0};
        double[] observations = new double[]{2.0};
        int j = 0;
        while (j < configSpace.getCategoricalSize().length) {
            indicesOfObservations[0] = j;
            ArrayList<Double> as = new ArrayList<Double>();
            int l = 0;
            while (l < configSpace.getCategoricalSize()[j]) {
                observations[0] = l;
                double marg = regtree.marginalPerformance(indicesOfObservations, observations);
                as.add(marg);
                ++l;
            }
            double avg = 0.0;
            for (Double entry : as) {
                avg += entry.doubleValue();
            }
            avg /= (double)as.size() + 0.0;
            double varianceContribution = 0.0;
            for (Double entry : as) {
                varianceContribution += 1.0 / ((double)as.size() + 0.0) * Math.pow(entry - avg, 2.0);
            }
            singleVarianceContributions.put(j, varianceContribution);
            ++j;
        }
        return singleVarianceContributions;
    }
}

