/*
 * Decompiled with CFR 0.152.
 */
package net.aclib.fanova.options;

import ca.ubc.cs.beta.aclib.help.HelpOptions;
import ca.ubc.cs.beta.aclib.logging.ComplexLoggingOptions;
import ca.ubc.cs.beta.aclib.logging.LoggingOptions;
import ca.ubc.cs.beta.aclib.misc.jcommander.validator.ZeroOneHalfOpenLeftDouble;
import ca.ubc.cs.beta.aclib.misc.options.UsageTextField;
import ca.ubc.cs.beta.aclib.model.ModelBuildingOptions;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.options.RandomForestOptions;
import ca.ubc.cs.beta.aclib.options.RunGroupOptions;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.random.SeedOptions;
import ca.ubc.cs.beta.aclib.state.StateFactoryOptions;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.util.HashSet;
import net.aclib.fanova.options.FAnovaNoArgumentHandler;

@UsageTextField(title="Functional Anova Options", noarg=FAnovaNoArgumentHandler.class)
public class FAnovaOptions
extends AbstractOptions {
    @ParametersDelegate
    public StateFactoryOptions stateFactoryOptions = new StateFactoryOptions();
    @ParametersDelegate
    public RandomForestOptions rfOptions = new RandomForestOptions();
    @ParametersDelegate
    public ScenarioOptions scenOpts = new ScenarioOptions();
    @ParametersDelegate
    public LoggingOptions loggingOptions = new ComplexLoggingOptions();
    @ParametersDelegate
    public HelpOptions helpOptions = new HelpOptions();
    @Parameter(names={"--compute-pairwise-interactions"}, description="If true compute and report the pairwise interaction effects between parameters")
    public boolean computePairwiseInteration = true;
    @Parameter(names={"--plot-marginals"}, description="If true a plot is generated for each predictive marginal (this will generate a data file, a gnuplot file, and a PDF for each parameter)")
    public boolean plotMarginals = true;
    @ParametersDelegate
    public ModelBuildingOptions mbOptions = new ModelBuildingOptions();
    @ParametersDelegate
    public SeedOptions seedOptions = new SeedOptions();
    @Parameter(names={"--quantile-to-compare"}, description="Quantile to compare to (if using QUANTILE --improvements-over)", validateWith=ZeroOneHalfOpenLeftDouble.class)
    public double quantileToCompare = 0.25;
    @Parameter(names={"--improvements-over"}, description="Compute improvements with respect to (this setting)")
    public Improvements compare = Improvements.NOTHING;
    @Parameter(names={"--num-training-samples"}, description="Number of training examples to use for fANOVA (-1 = all)")
    public int numTrainingSamples = -1;
    @Parameter(names={"--ipc-port"}, description="port for remote connections")
    public int port = 5050;
    @Parameter(names={"--mode"}, description="either ipc or commandline")
    public String mode = "ipc";
    @ParametersDelegate
    public RunGroupOptions runGroupOptions = new RunGroupOptions("%SCENARIO_NAME-improvOver%improvementsOver-quant%quantileToCompare-n%rfNumTrees-sm%rfSplitMin-it%restoreIteration");

    public FAnovaOptions() {
        this.scenOpts.outputDirectory = String.valueOf(System.getProperty("user.dir")) + File.separator + "fanova-output";
    }

    public String getRunGroupName() {
        HashSet<FAnovaOptions> opts = new HashSet<FAnovaOptions>();
        opts.add(this);
        return this.runGroupOptions.getRunGroupName(opts);
    }

    public static enum Improvements {
        DEFAULT,
        QUANTILE,
        NOTHING;

    }
}

