/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.example.tae;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.example.tae.TargetAlgorithmEvaluatorRunnerOptions;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAlgorithmEvaluatorRunner {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        TargetAlgorithmEvaluatorRunnerOptions mainOptions = new TargetAlgorithmEvaluatorRunnerOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.scenOptions.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        try {
            JCommander jcom;
            try {
                jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
            }
            finally {
                TargetAlgorithmEvaluatorRunner.initializeLogger();
            }
            VersionTracker.logVersions();
            for (String name : jcom.getParameterFilesToRead()) {
                log.info("Parsing (default) options from file: {} ", (Object)name);
            }
            AlgorithmExecutionConfig execConfig = mainOptions.getAlgorithmExecutionConfig();
            log.info("==== Configuration====\n {} ", (Object)mainOptions);
            TargetAlgorithmEvaluator tae = null;
            try {
                ProblemInstance pi;
                tae = mainOptions.scenOptions.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(execConfig, taeOptions);
                if (mainOptions.instanceName == null) {
                    List<ProblemInstance> instances = mainOptions.getTrainingAndTestProblemInstances().getTrainingInstances().getInstances();
                    if (instances == null || instances.size() == 0) {
                        throw new ParameterException("No instances available, please specify one manually via --instance argument");
                    }
                    pi = instances.get(0);
                } else {
                    pi = new ProblemInstance(mainOptions.instanceName);
                }
                if (execConfig.isDeterministicAlgorithm()) {
                    if (mainOptions.seed != -1L) {
                        log.warn("It is convention to use -1 as the seed for deterministic algorithms");
                    }
                } else if (mainOptions.seed == -1L) {
                    log.warn("It is convention that -1 be used as seed only for deterministic algorithms");
                }
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, mainOptions.seed);
                ParamConfigurationSpace configSpace = execConfig.getParamFile();
                MersenneTwister configSpacePRNG = new MersenneTwister(mainOptions.configSeed);
                ParamConfiguration config = configSpace.getConfigurationFromString(mainOptions.config, ParamConfiguration.StringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG);
                for (Map.Entry<String, String> entry : mainOptions.configSettingsToOverride.entrySet()) {
                    config.put(entry.getKey(), entry.getValue());
                }
                RunConfig runConfig = new RunConfig(pisp, execConfig.getAlgorithmCutoffTime(), config);
                TargetAlgorithmEvaluatorRunner.processRunConfig(runConfig, tae, mainOptions.killTime);
            }
            finally {
                if (tae != null) {
                    tae.notifyShutdown();
                }
            }
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initializeLogger() {
        log = LoggerFactory.getLogger(TargetAlgorithmEvaluatorRunner.class);
    }

    public static void processRunConfig(RunConfig runConfig, TargetAlgorithmEvaluator tae, final double killTime) {
        TargetAlgorithmEvaluatorRunObserver runStatus = new TargetAlgorithmEvaluatorRunObserver(){
            private long lastUpdate = 0L;

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                if (System.currentTimeMillis() - this.lastUpdate < 1000L) {
                    return;
                }
                for (int i = 0; i < runs.size(); ++i) {
                    KillableAlgorithmRun run = runs.get(i);
                    Object[] logArguments = new Object[]{i, run.getRunConfig().getProblemInstanceSeedPair().getInstance(), run.getRunResult(), run.getRuntime()};
                    log.info("Run {} on {} has status =>  {}, {}", logArguments);
                    if (!(run.getRuntime() > killTime)) continue;
                    log.info("Dynamically killing run");
                    run.kill();
                }
                this.lastUpdate = System.currentTimeMillis();
            }
        };
        List<AlgorithmRun> runResults = tae.evaluateRun(Collections.singletonList(runConfig), runStatus);
        log.info("Run Completed");
        for (int i = 0; i < runResults.size(); ++i) {
            AlgorithmRun run = runResults.get(i);
            RunConfig resultRunConfig = run.getRunConfig();
            RunResult runResult = run.getRunResult();
            double runtime = run.getRuntime();
            double runLength = run.getRunLength();
            double quality = run.getQuality();
            long resultSeed = run.getResultSeed();
            long requestSeed = resultRunConfig.getProblemInstanceSeedPair().getSeed();
            String additionalData = run.getAdditionalRunData();
            if (resultSeed != requestSeed) {
                log.error("Algorithm Run Result does not have a matching seed, requested: {} , returned: {}", (Object)resultSeed, (Object)requestSeed);
            }
            String configString = resultRunConfig.getParamConfiguration().getFormattedParamString(ParamConfiguration.StringFormat.NODB_OR_STATEFILE_SYNTAX);
            Object[] logArguments = new Object[]{i, resultRunConfig.getProblemInstanceSeedPair().getInstance(), configString, runResult, runtime, runLength, quality, resultSeed, additionalData};
            log.info("Run {} on {} with config: {} had the result => {}, {}, {}, {}, {}, {}", logArguments);
        }
    }
}

