/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.logging;

import ca.ubc.cs.beta.aclib.logging.LogLevel;
import ca.ubc.cs.beta.aclib.logging.LoggingOptions;
import ca.ubc.cs.beta.aclib.misc.options.CommandLineOnly;
import ca.ubc.cs.beta.aclib.misc.options.OptionLevel;
import ca.ubc.cs.beta.aclib.misc.options.UsageTextField;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import com.beust.jcommander.Parameter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsageTextField(hiddenSection=true)
public class SingleLogFileLoggingOptions
extends AbstractOptions
implements LoggingOptions {
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--console-log-level", "--consoleLogLevel"}, description="default log level of console output (this cannot be more verbose than the logLevel)")
    public LogLevel consoleLogLevel = LogLevel.INFO;
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--log-level", "--logLevel"}, description="messages will only be logged if they are of this severity or higher.")
    public LogLevel logLevel = LogLevel.DEBUG;
    public boolean suppressLogLevelConsistencyWarning = false;
    private final String prefix;

    public SingleLogFileLoggingOptions() {
        this.prefix = "";
    }

    public SingleLogFileLoggingOptions(String prefix) {
        if (prefix.matches("\\s")) {
            throw new IllegalArgumentException("Prefix cannot contain whitespace");
        }
        this.prefix = prefix + "-";
    }

    @Override
    public void initializeLogging(String completeOutputDir, int numRun) {
        Logger log;
        if (completeOutputDir == null) {
            completeOutputDir = new File("").getAbsolutePath();
        }
        System.setProperty("LOGLEVEL", this.logLevel.name());
        System.setProperty("OUTPUTDIR", completeOutputDir);
        System.setProperty("NUMRUN", String.valueOf(numRun));
        System.setProperty("STDOUT-LEVEL", this.consoleLogLevel.name());
        System.setProperty("ROOT-LEVEL", this.logLevel.name());
        String logLocation = this.getLogLocation(completeOutputDir, numRun);
        System.setProperty("RUNLOG", logLocation);
        System.out.println("*****************************\nLogging to: " + logLocation + "\n*****************************");
        if (System.getProperty("logback.configurationFile") != null) {
            log = LoggerFactory.getLogger(this.getClass());
            log.debug("System property for logback.configurationFile has been found already set as {} , logging will follow this file", (Object)System.getProperty("logback.configurationFile"));
        } else {
            String newXML = this.getClass().getPackage().getName().replace(".", File.separator) + File.separator + "singlefile-logback.xml";
            System.setProperty("logback.configurationFile", newXML);
            Logger log2 = LoggerFactory.getLogger(this.getClass());
            if (log2.isDebugEnabled()) {
                log2.debug("Logging initialized to use file:" + newXML);
            } else {
                log2.info("Logging initialized");
            }
        }
        log = LoggerFactory.getLogger(SingleLogFileLoggingOptions.class);
        log.info("Logging to: {}", (Object)logLocation);
        if (!this.suppressLogLevelConsistencyWarning && this.logLevel.lessVerbose(this.consoleLogLevel)) {
            log.warn("The console has been set to be more verbose than the log. This is generally an error, except if you have modified the logback.xml to have certain loggers be more specific");
        }
    }

    public String getLogLocation(String completeOutputDir, int numRun) {
        if (completeOutputDir == null) {
            completeOutputDir = new File("").getAbsolutePath();
        }
        return completeOutputDir + File.separator + "log-" + this.prefix + numRun + ".txt";
    }

    @Override
    public void initializeLogging() {
        this.initializeLogging(new File(".").getAbsolutePath(), 0);
    }
}

